package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait SubscriptionStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.SubscriptionStatus
}
object SubscriptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.SubscriptionStatus
  ): zio.aws.sesv2.model.SubscriptionStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.OPT_IN =>
      val r = OPT_IN
      r
    case software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.OPT_OUT =>
      val r = OPT_OUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.SubscriptionStatus =
      software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OPT_IN extends zio.aws.sesv2.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.SubscriptionStatus =
      software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.OPT_IN
  }
  case object OPT_OUT extends zio.aws.sesv2.model.SubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.SubscriptionStatus =
      software.amazon.awssdk.services.sesv2.model.SubscriptionStatus.OPT_OUT
  }
}
