package zio.aws.sesv2.model
import java.lang.Integer
import zio.aws.sesv2.model.primitives.{Percentage100Wrapper, Ip}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutDedicatedIpWarmupAttributesRequest(
    ip: Ip,
    warmupPercentage: Percentage100Wrapper
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest = {
    import PutDedicatedIpWarmupAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest
      .builder()
      .ip(Ip.unwrap(ip): java.lang.String)
      .warmupPercentage(Percentage100Wrapper.unwrap(warmupPercentage): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest
      .wrap(buildAwsValue())
}
object PutDedicatedIpWarmupAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest =
      zio.aws.sesv2.model
        .PutDedicatedIpWarmupAttributesRequest(ip, warmupPercentage)
    def ip: Ip
    def warmupPercentage: Percentage100Wrapper
    def getIp: ZIO[Any, Nothing, Ip] = ZIO.succeed(ip)
    def getWarmupPercentage: ZIO[Any, Nothing, Percentage100Wrapper] =
      ZIO.succeed(warmupPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest
  ) extends zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest.ReadOnly {
    override val ip: Ip = zio.aws.sesv2.model.primitives.Ip(impl.ip())
    override val warmupPercentage: Percentage100Wrapper =
      zio.aws.sesv2.model.primitives
        .Percentage100Wrapper(impl.warmupPercentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest
  ): zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
