package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Percentage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OverallVolume(
    volumeStatistics: Optional[zio.aws.sesv2.model.VolumeStatistics] =
      Optional.Absent,
    readRatePercent: Optional[Percentage] = Optional.Absent,
    domainIspPlacements: Optional[
      Iterable[zio.aws.sesv2.model.DomainIspPlacement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.OverallVolume = {
    import OverallVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.OverallVolume
      .builder()
      .optionallyWith(volumeStatistics.map(value => value.buildAwsValue()))(
        _.volumeStatistics
      )
      .optionallyWith(
        readRatePercent.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readRatePercent)
      .optionallyWith(
        domainIspPlacements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainIspPlacements)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.OverallVolume.ReadOnly =
    zio.aws.sesv2.model.OverallVolume.wrap(buildAwsValue())
}
object OverallVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.OverallVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.OverallVolume =
      zio.aws.sesv2.model.OverallVolume(
        volumeStatistics.map(value => value.asEditable),
        readRatePercent.map(value => value),
        domainIspPlacements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeStatistics
        : Optional[zio.aws.sesv2.model.VolumeStatistics.ReadOnly]
    def readRatePercent: Optional[Percentage]
    def domainIspPlacements
        : Optional[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]]
    def getVolumeStatistics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VolumeStatistics.ReadOnly] =
      AwsError.unwrapOptionField("volumeStatistics", volumeStatistics)
    def getReadRatePercent: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readRatePercent", readRatePercent)
    def getDomainIspPlacements: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainIspPlacement.ReadOnly
    ]] = AwsError.unwrapOptionField("domainIspPlacements", domainIspPlacements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.OverallVolume
  ) extends zio.aws.sesv2.model.OverallVolume.ReadOnly {
    override val volumeStatistics
        : Optional[zio.aws.sesv2.model.VolumeStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeStatistics())
        .map(value => zio.aws.sesv2.model.VolumeStatistics.wrap(value))
    override val readRatePercent: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.readRatePercent())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val domainIspPlacements
        : Optional[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainIspPlacements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.DomainIspPlacement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.OverallVolume
  ): zio.aws.sesv2.model.OverallVolume.ReadOnly = new Wrapper(impl)
}
