package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRecommendationsResponse(
    recommendations: Optional[Iterable[zio.aws.sesv2.model.Recommendation]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse = {
    import ListRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse
      .builder()
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly =
    zio.aws.sesv2.model.ListRecommendationsResponse.wrap(buildAwsValue())
}
object ListRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListRecommendationsResponse =
      zio.aws.sesv2.model.ListRecommendationsResponse(
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def recommendations
        : Optional[List[zio.aws.sesv2.model.Recommendation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse
  ) extends zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly {
    override val recommendations
        : Optional[List[zio.aws.sesv2.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Recommendation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListRecommendationsResponse
  ): zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
