package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  FailedRecordsCount,
  ProcessedRecordsCount,
  Timestamp,
  JobId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ImportJobSummary(
    jobId: Optional[JobId] = Optional.Absent,
    importDestination: Optional[zio.aws.sesv2.model.ImportDestination] =
      Optional.Absent,
    jobStatus: Optional[zio.aws.sesv2.model.JobStatus] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    processedRecordsCount: Optional[ProcessedRecordsCount] = Optional.Absent,
    failedRecordsCount: Optional[FailedRecordsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ImportJobSummary = {
    import ImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ImportJobSummary
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(importDestination.map(value => value.buildAwsValue()))(
        _.importDestination
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        processedRecordsCount.map(value =>
          ProcessedRecordsCount.unwrap(value): Integer
        )
      )(_.processedRecordsCount)
      .optionallyWith(
        failedRecordsCount.map(value =>
          FailedRecordsCount.unwrap(value): Integer
        )
      )(_.failedRecordsCount)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ImportJobSummary.ReadOnly =
    zio.aws.sesv2.model.ImportJobSummary.wrap(buildAwsValue())
}
object ImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ImportJobSummary =
      zio.aws.sesv2.model.ImportJobSummary(
        jobId.map(value => value),
        importDestination.map(value => value.asEditable),
        jobStatus.map(value => value),
        createdTimestamp.map(value => value),
        processedRecordsCount.map(value => value),
        failedRecordsCount.map(value => value)
      )
    def jobId: Optional[JobId]
    def importDestination
        : Optional[zio.aws.sesv2.model.ImportDestination.ReadOnly]
    def jobStatus: Optional[zio.aws.sesv2.model.JobStatus]
    def createdTimestamp: Optional[Timestamp]
    def processedRecordsCount: Optional[ProcessedRecordsCount]
    def failedRecordsCount: Optional[FailedRecordsCount]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getImportDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      AwsError.unwrapOptionField("importDestination", importDestination)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getProcessedRecordsCount: ZIO[Any, AwsError, ProcessedRecordsCount] =
      AwsError.unwrapOptionField("processedRecordsCount", processedRecordsCount)
    def getFailedRecordsCount: ZIO[Any, AwsError, FailedRecordsCount] =
      AwsError.unwrapOptionField("failedRecordsCount", failedRecordsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ) extends zio.aws.sesv2.model.ImportJobSummary.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.sesv2.model.primitives.JobId(value))
    override val importDestination
        : Optional[zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importDestination())
        .map(value => zio.aws.sesv2.model.ImportDestination.wrap(value))
    override val jobStatus: Optional[zio.aws.sesv2.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.sesv2.model.JobStatus.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val processedRecordsCount: Optional[ProcessedRecordsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processedRecordsCount())
        .map(value =>
          zio.aws.sesv2.model.primitives.ProcessedRecordsCount(value)
        )
    override val failedRecordsCount: Optional[FailedRecordsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedRecordsCount())
        .map(value => zio.aws.sesv2.model.primitives.FailedRecordsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ImportJobSummary
  ): zio.aws.sesv2.model.ImportJobSummary.ReadOnly = new Wrapper(impl)
}
