package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  FailedRecordsCount,
  ProcessedRecordsCount,
  Timestamp,
  JobId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetImportJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    importDestination: Optional[zio.aws.sesv2.model.ImportDestination] =
      Optional.Absent,
    importDataSource: Optional[zio.aws.sesv2.model.ImportDataSource] =
      Optional.Absent,
    failureInfo: Optional[zio.aws.sesv2.model.FailureInfo] = Optional.Absent,
    jobStatus: Optional[zio.aws.sesv2.model.JobStatus] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    completedTimestamp: Optional[Timestamp] = Optional.Absent,
    processedRecordsCount: Optional[ProcessedRecordsCount] = Optional.Absent,
    failedRecordsCount: Optional[FailedRecordsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetImportJobResponse = {
    import GetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(importDestination.map(value => value.buildAwsValue()))(
        _.importDestination
      )
      .optionallyWith(importDataSource.map(value => value.buildAwsValue()))(
        _.importDataSource
      )
      .optionallyWith(failureInfo.map(value => value.buildAwsValue()))(
        _.failureInfo
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        completedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedTimestamp)
      .optionallyWith(
        processedRecordsCount.map(value =>
          ProcessedRecordsCount.unwrap(value): Integer
        )
      )(_.processedRecordsCount)
      .optionallyWith(
        failedRecordsCount.map(value =>
          FailedRecordsCount.unwrap(value): Integer
        )
      )(_.failedRecordsCount)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetImportJobResponse.ReadOnly =
    zio.aws.sesv2.model.GetImportJobResponse.wrap(buildAwsValue())
}
object GetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetImportJobResponse =
      zio.aws.sesv2.model.GetImportJobResponse(
        jobId.map(value => value),
        importDestination.map(value => value.asEditable),
        importDataSource.map(value => value.asEditable),
        failureInfo.map(value => value.asEditable),
        jobStatus.map(value => value),
        createdTimestamp.map(value => value),
        completedTimestamp.map(value => value),
        processedRecordsCount.map(value => value),
        failedRecordsCount.map(value => value)
      )
    def jobId: Optional[JobId]
    def importDestination
        : Optional[zio.aws.sesv2.model.ImportDestination.ReadOnly]
    def importDataSource
        : Optional[zio.aws.sesv2.model.ImportDataSource.ReadOnly]
    def failureInfo: Optional[zio.aws.sesv2.model.FailureInfo.ReadOnly]
    def jobStatus: Optional[zio.aws.sesv2.model.JobStatus]
    def createdTimestamp: Optional[Timestamp]
    def completedTimestamp: Optional[Timestamp]
    def processedRecordsCount: Optional[ProcessedRecordsCount]
    def failedRecordsCount: Optional[FailedRecordsCount]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getImportDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      AwsError.unwrapOptionField("importDestination", importDestination)
    def getImportDataSource
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDataSource.ReadOnly] =
      AwsError.unwrapOptionField("importDataSource", importDataSource)
    def getFailureInfo
        : ZIO[Any, AwsError, zio.aws.sesv2.model.FailureInfo.ReadOnly] =
      AwsError.unwrapOptionField("failureInfo", failureInfo)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCompletedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedTimestamp", completedTimestamp)
    def getProcessedRecordsCount: ZIO[Any, AwsError, ProcessedRecordsCount] =
      AwsError.unwrapOptionField("processedRecordsCount", processedRecordsCount)
    def getFailedRecordsCount: ZIO[Any, AwsError, FailedRecordsCount] =
      AwsError.unwrapOptionField("failedRecordsCount", failedRecordsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ) extends zio.aws.sesv2.model.GetImportJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.sesv2.model.primitives.JobId(value))
    override val importDestination
        : Optional[zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importDestination())
        .map(value => zio.aws.sesv2.model.ImportDestination.wrap(value))
    override val importDataSource
        : Optional[zio.aws.sesv2.model.ImportDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importDataSource())
        .map(value => zio.aws.sesv2.model.ImportDataSource.wrap(value))
    override val failureInfo
        : Optional[zio.aws.sesv2.model.FailureInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureInfo())
        .map(value => zio.aws.sesv2.model.FailureInfo.wrap(value))
    override val jobStatus: Optional[zio.aws.sesv2.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.sesv2.model.JobStatus.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val completedTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completedTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val processedRecordsCount: Optional[ProcessedRecordsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processedRecordsCount())
        .map(value =>
          zio.aws.sesv2.model.primitives.ProcessedRecordsCount(value)
        )
    override val failedRecordsCount: Optional[FailedRecordsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedRecordsCount())
        .map(value => zio.aws.sesv2.model.primitives.FailedRecordsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobResponse
  ): zio.aws.sesv2.model.GetImportJobResponse.ReadOnly = new Wrapper(impl)
}
