package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{GeneralEnforcementStatus, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountResponse(
    dedicatedIpAutoWarmupEnabled: Optional[Enabled] = Optional.Absent,
    enforcementStatus: Optional[GeneralEnforcementStatus] = Optional.Absent,
    productionAccessEnabled: Optional[Enabled] = Optional.Absent,
    sendQuota: Optional[zio.aws.sesv2.model.SendQuota] = Optional.Absent,
    sendingEnabled: Optional[Enabled] = Optional.Absent,
    suppressionAttributes: Optional[zio.aws.sesv2.model.SuppressionAttributes] =
      Optional.Absent,
    details: Optional[zio.aws.sesv2.model.AccountDetails] = Optional.Absent,
    vdmAttributes: Optional[zio.aws.sesv2.model.VdmAttributes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetAccountResponse
      .builder()
      .optionallyWith(
        dedicatedIpAutoWarmupEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedIpAutoWarmupEnabled)
      .optionallyWith(
        enforcementStatus.map(value =>
          GeneralEnforcementStatus.unwrap(value): java.lang.String
        )
      )(_.enforcementStatus)
      .optionallyWith(
        productionAccessEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.productionAccessEnabled)
      .optionallyWith(sendQuota.map(value => value.buildAwsValue()))(
        _.sendQuota
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(
        suppressionAttributes.map(value => value.buildAwsValue())
      )(_.suppressionAttributes)
      .optionallyWith(details.map(value => value.buildAwsValue()))(_.details)
      .optionallyWith(vdmAttributes.map(value => value.buildAwsValue()))(
        _.vdmAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetAccountResponse.ReadOnly =
    zio.aws.sesv2.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetAccountResponse =
      zio.aws.sesv2.model.GetAccountResponse(
        dedicatedIpAutoWarmupEnabled.map(value => value),
        enforcementStatus.map(value => value),
        productionAccessEnabled.map(value => value),
        sendQuota.map(value => value.asEditable),
        sendingEnabled.map(value => value),
        suppressionAttributes.map(value => value.asEditable),
        details.map(value => value.asEditable),
        vdmAttributes.map(value => value.asEditable)
      )
    def dedicatedIpAutoWarmupEnabled: Optional[Enabled]
    def enforcementStatus: Optional[GeneralEnforcementStatus]
    def productionAccessEnabled: Optional[Enabled]
    def sendQuota: Optional[zio.aws.sesv2.model.SendQuota.ReadOnly]
    def sendingEnabled: Optional[Enabled]
    def suppressionAttributes
        : Optional[zio.aws.sesv2.model.SuppressionAttributes.ReadOnly]
    def details: Optional[zio.aws.sesv2.model.AccountDetails.ReadOnly]
    def vdmAttributes: Optional[zio.aws.sesv2.model.VdmAttributes.ReadOnly]
    def getDedicatedIpAutoWarmupEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "dedicatedIpAutoWarmupEnabled",
        dedicatedIpAutoWarmupEnabled
      )
    def getEnforcementStatus: ZIO[Any, AwsError, GeneralEnforcementStatus] =
      AwsError.unwrapOptionField("enforcementStatus", enforcementStatus)
    def getProductionAccessEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("productionAccessEnabled", productionAccessEnabled)
    def getSendQuota
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SendQuota.ReadOnly] =
      AwsError.unwrapOptionField("sendQuota", sendQuota)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getSuppressionAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressionAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("suppressionAttributes", suppressionAttributes)
    def getDetails
        : ZIO[Any, AwsError, zio.aws.sesv2.model.AccountDetails.ReadOnly] =
      AwsError.unwrapOptionField("details", details)
    def getVdmAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VdmAttributes.ReadOnly] =
      AwsError.unwrapOptionField("vdmAttributes", vdmAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ) extends zio.aws.sesv2.model.GetAccountResponse.ReadOnly {
    override val dedicatedIpAutoWarmupEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIpAutoWarmupEnabled())
        .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val enforcementStatus: Optional[GeneralEnforcementStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enforcementStatus())
        .map(value =>
          zio.aws.sesv2.model.primitives.GeneralEnforcementStatus(value)
        )
    override val productionAccessEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productionAccessEnabled())
        .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val sendQuota: Optional[zio.aws.sesv2.model.SendQuota.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendQuota())
        .map(value => zio.aws.sesv2.model.SendQuota.wrap(value))
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val suppressionAttributes
        : Optional[zio.aws.sesv2.model.SuppressionAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressionAttributes())
        .map(value => zio.aws.sesv2.model.SuppressionAttributes.wrap(value))
    override val details
        : Optional[zio.aws.sesv2.model.AccountDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value => zio.aws.sesv2.model.AccountDetails.wrap(value))
    override val vdmAttributes
        : Optional[zio.aws.sesv2.model.VdmAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vdmAttributes())
        .map(value => zio.aws.sesv2.model.VdmAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetAccountResponse
  ): zio.aws.sesv2.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
