package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, DnsToken, Enabled}
import scala.jdk.CollectionConverters.*
final case class DkimAttributes(
    signingEnabled: Optional[Enabled] = Optional.Absent,
    status: Optional[zio.aws.sesv2.model.DkimStatus] = Optional.Absent,
    tokens: Optional[Iterable[DnsToken]] = Optional.Absent,
    signingAttributesOrigin: Optional[
      zio.aws.sesv2.model.DkimSigningAttributesOrigin
    ] = Optional.Absent,
    nextSigningKeyLength: Optional[zio.aws.sesv2.model.DkimSigningKeyLength] =
      Optional.Absent,
    currentSigningKeyLength: Optional[
      zio.aws.sesv2.model.DkimSigningKeyLength
    ] = Optional.Absent,
    lastKeyGenerationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DkimAttributes = {
    import DkimAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DkimAttributes
      .builder()
      .optionallyWith(
        signingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.signingEnabled)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tokens.map(value =>
          value.map { item =>
            DnsToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokens)
      .optionallyWith(signingAttributesOrigin.map(value => value.unwrap))(
        _.signingAttributesOrigin
      )
      .optionallyWith(nextSigningKeyLength.map(value => value.unwrap))(
        _.nextSigningKeyLength
      )
      .optionallyWith(currentSigningKeyLength.map(value => value.unwrap))(
        _.currentSigningKeyLength
      )
      .optionallyWith(
        lastKeyGenerationTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastKeyGenerationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DkimAttributes.ReadOnly =
    zio.aws.sesv2.model.DkimAttributes.wrap(buildAwsValue())
}
object DkimAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DkimAttributes =
      zio.aws.sesv2.model.DkimAttributes(
        signingEnabled.map(value => value),
        status.map(value => value),
        tokens.map(value => value),
        signingAttributesOrigin.map(value => value),
        nextSigningKeyLength.map(value => value),
        currentSigningKeyLength.map(value => value),
        lastKeyGenerationTimestamp.map(value => value)
      )
    def signingEnabled: Optional[Enabled]
    def status: Optional[zio.aws.sesv2.model.DkimStatus]
    def tokens: Optional[List[DnsToken]]
    def signingAttributesOrigin
        : Optional[zio.aws.sesv2.model.DkimSigningAttributesOrigin]
    def nextSigningKeyLength: Optional[zio.aws.sesv2.model.DkimSigningKeyLength]
    def currentSigningKeyLength
        : Optional[zio.aws.sesv2.model.DkimSigningKeyLength]
    def lastKeyGenerationTimestamp: Optional[Timestamp]
    def getSigningEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("signingEnabled", signingEnabled)
    def getStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.DkimStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTokens: ZIO[Any, AwsError, List[DnsToken]] =
      AwsError.unwrapOptionField("tokens", tokens)
    def getSigningAttributesOrigin
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningAttributesOrigin] =
      AwsError.unwrapOptionField(
        "signingAttributesOrigin",
        signingAttributesOrigin
      )
    def getNextSigningKeyLength
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningKeyLength] =
      AwsError.unwrapOptionField("nextSigningKeyLength", nextSigningKeyLength)
    def getCurrentSigningKeyLength
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningKeyLength] =
      AwsError.unwrapOptionField(
        "currentSigningKeyLength",
        currentSigningKeyLength
      )
    def getLastKeyGenerationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastKeyGenerationTimestamp",
        lastKeyGenerationTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ) extends zio.aws.sesv2.model.DkimAttributes.ReadOnly {
    override val signingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.signingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val status: Optional[zio.aws.sesv2.model.DkimStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sesv2.model.DkimStatus.wrap(value))
    override val tokens: Optional[List[DnsToken]] = zio.aws.core.internal
      .optionalFromNullable(impl.tokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.DnsToken(item)
        }.toList
      )
    override val signingAttributesOrigin
        : Optional[zio.aws.sesv2.model.DkimSigningAttributesOrigin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAttributesOrigin())
        .map(value =>
          zio.aws.sesv2.model.DkimSigningAttributesOrigin.wrap(value)
        )
    override val nextSigningKeyLength
        : Optional[zio.aws.sesv2.model.DkimSigningKeyLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextSigningKeyLength())
        .map(value => zio.aws.sesv2.model.DkimSigningKeyLength.wrap(value))
    override val currentSigningKeyLength
        : Optional[zio.aws.sesv2.model.DkimSigningKeyLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentSigningKeyLength())
        .map(value => zio.aws.sesv2.model.DkimSigningKeyLength.wrap(value))
    override val lastKeyGenerationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastKeyGenerationTimestamp())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DkimAttributes
  ): zio.aws.sesv2.model.DkimAttributes.ReadOnly = new Wrapper(impl)
}
