package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DashboardOptions(
    engagementMetrics: Optional[zio.aws.sesv2.model.FeatureStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DashboardOptions = {
    import DashboardOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DashboardOptions
      .builder()
      .optionallyWith(engagementMetrics.map(value => value.unwrap))(
        _.engagementMetrics
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DashboardOptions.ReadOnly =
    zio.aws.sesv2.model.DashboardOptions.wrap(buildAwsValue())
}
object DashboardOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DashboardOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DashboardOptions = zio.aws.sesv2.model
      .DashboardOptions(engagementMetrics.map(value => value))
    def engagementMetrics: Optional[zio.aws.sesv2.model.FeatureStatus]
    def getEngagementMetrics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.FeatureStatus] =
      AwsError.unwrapOptionField("engagementMetrics", engagementMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DashboardOptions
  ) extends zio.aws.sesv2.model.DashboardOptions.ReadOnly {
    override val engagementMetrics
        : Optional[zio.aws.sesv2.model.FeatureStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.engagementMetrics())
      .map(value => zio.aws.sesv2.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DashboardOptions
  ): zio.aws.sesv2.model.DashboardOptions.ReadOnly = new Wrapper(impl)
}
