package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DashboardAttributes(
    engagementMetrics: Optional[zio.aws.sesv2.model.FeatureStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DashboardAttributes = {
    import DashboardAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DashboardAttributes
      .builder()
      .optionallyWith(engagementMetrics.map(value => value.unwrap))(
        _.engagementMetrics
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DashboardAttributes.ReadOnly =
    zio.aws.sesv2.model.DashboardAttributes.wrap(buildAwsValue())
}
object DashboardAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DashboardAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DashboardAttributes =
      zio.aws.sesv2.model
        .DashboardAttributes(engagementMetrics.map(value => value))
    def engagementMetrics: Optional[zio.aws.sesv2.model.FeatureStatus]
    def getEngagementMetrics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.FeatureStatus] =
      AwsError.unwrapOptionField("engagementMetrics", engagementMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DashboardAttributes
  ) extends zio.aws.sesv2.model.DashboardAttributes.ReadOnly {
    override val engagementMetrics
        : Optional[zio.aws.sesv2.model.FeatureStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.engagementMetrics())
      .map(value => zio.aws.sesv2.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DashboardAttributes
  ): zio.aws.sesv2.model.DashboardAttributes.ReadOnly = new Wrapper(impl)
}
