package zio.aws.sesv2
import zio.aws.sesv2.model.GetDedicatedIpPoolResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sesv2.{
  SesV2AsyncClientBuilder,
  SesV2AsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.sesv2.model.{
  CreateContactResponse,
  GetContactListResponse,
  DeleteSuppressedDestinationRequest,
  EmailTemplateMetadata,
  PutEmailIdentityConfigurationSetAttributesRequest,
  DeleteSuppressedDestinationResponse,
  DeleteDedicatedIpPoolRequest,
  CreateEmailTemplateResponse,
  GetDedicatedIpResponse,
  GetDedicatedIpPoolResponse,
  UpdateContactListResponse,
  DeleteEmailTemplateResponse,
  GetAccountResponse,
  PutAccountDedicatedIpWarmupAttributesResponse,
  ListEmailTemplatesResponse,
  DeleteConfigurationSetEventDestinationResponse,
  GetDeliverabilityDashboardOptionsResponse,
  PutSuppressedDestinationResponse,
  ListImportJobsResponse,
  DedicatedIp,
  ListDomainDeliverabilityCampaignsResponse,
  UpdateEmailIdentityPolicyRequest,
  TestRenderEmailTemplateRequest,
  GetEmailIdentityPoliciesRequest,
  CreateContactRequest,
  UpdateContactListRequest,
  ListContactsResponse,
  GetCustomVerificationEmailTemplateResponse,
  DeleteConfigurationSetResponse,
  SendEmailResponse,
  PutEmailIdentityFeedbackAttributesResponse,
  PutConfigurationSetSuppressionOptionsRequest,
  ContactList,
  DeleteConfigurationSetRequest,
  PutDeliverabilityDashboardOptionRequest,
  PutEmailIdentityConfigurationSetAttributesResponse,
  DeleteContactListRequest,
  ListConfigurationSetsResponse,
  GetDedicatedIpRequest,
  CreateConfigurationSetEventDestinationResponse,
  UpdateConfigurationSetEventDestinationRequest,
  DeleteCustomVerificationEmailTemplateRequest,
  GetDedicatedIpsResponse,
  CreateDeliverabilityTestReportRequest,
  DeleteContactRequest,
  ListContactListsResponse,
  PutEmailIdentityDkimSigningAttributesResponse,
  DeliverabilityTestReport,
  GetDomainDeliverabilityCampaignRequest,
  ListSuppressedDestinationsResponse,
  DomainDeliverabilityCampaign,
  CreateContactListRequest,
  PutConfigurationSetSendingOptionsRequest,
  ListContactListsRequest,
  GetEmailIdentityRequest,
  PutAccountSendingAttributesRequest,
  PutAccountDetailsRequest,
  GetContactResponse,
  PutEmailIdentityFeedbackAttributesRequest,
  GetDomainDeliverabilityCampaignResponse,
  GetDedicatedIpPoolRequest,
  ListEmailTemplatesRequest,
  GetContactRequest,
  TestRenderEmailTemplateResponse,
  ListRecommendationsRequest,
  PutDedicatedIpWarmupAttributesRequest,
  UpdateContactResponse,
  ListTagsForResourceRequest,
  IdentityInfo,
  GetEmailIdentityResponse,
  GetImportJobResponse,
  GetEmailIdentityPoliciesResponse,
  UpdateEmailIdentityPolicyResponse,
  DeleteContactListResponse,
  CreateConfigurationSetRequest,
  SendBulkEmailResponse,
  CreateEmailIdentityRequest,
  CreateConfigurationSetResponse,
  UpdateConfigurationSetEventDestinationResponse,
  PutAccountDedicatedIpWarmupAttributesRequest,
  PutConfigurationSetSuppressionOptionsResponse,
  UpdateEmailTemplateRequest,
  GetEmailTemplateRequest,
  CreateDedicatedIpPoolResponse,
  PutAccountSuppressionAttributesResponse,
  PutAccountVdmAttributesRequest,
  DeleteCustomVerificationEmailTemplateResponse,
  CreateCustomVerificationEmailTemplateResponse,
  ListDedicatedIpPoolsResponse,
  CreateContactListResponse,
  CreateImportJobResponse,
  GetConfigurationSetRequest,
  GetBlacklistReportsRequest,
  SendCustomVerificationEmailResponse,
  UpdateCustomVerificationEmailTemplateResponse,
  PutEmailIdentityDkimAttributesResponse,
  ListImportJobsRequest,
  ListTagsForResourceResponse,
  GetDedicatedIpsRequest,
  UntagResourceResponse,
  PutConfigurationSetVdmOptionsResponse,
  ListEmailIdentitiesResponse,
  ListDedicatedIpPoolsRequest,
  CreateEmailIdentityPolicyRequest,
  ListEmailIdentitiesRequest,
  PutEmailIdentityDkimAttributesRequest,
  GetConfigurationSetEventDestinationsResponse,
  ListSuppressedDestinationsRequest,
  SendEmailRequest,
  PutConfigurationSetTrackingOptionsRequest,
  GetAccountRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  PutSuppressedDestinationRequest,
  ListConfigurationSetsRequest,
  SuppressedDestinationSummary,
  ImportJobSummary,
  UpdateCustomVerificationEmailTemplateRequest,
  PutEmailIdentityDkimSigningAttributesRequest,
  Recommendation,
  GetConfigurationSetEventDestinationsRequest,
  ListDeliverabilityTestReportsRequest,
  GetDomainStatisticsReportRequest,
  CreateEmailIdentityPolicyResponse,
  CreateConfigurationSetEventDestinationRequest,
  PutDedicatedIpWarmupAttributesResponse,
  BatchGetMetricDataRequest,
  Contact,
  PutAccountSuppressionAttributesRequest,
  GetBlacklistReportsResponse,
  DeleteEmailIdentityPolicyResponse,
  GetSuppressedDestinationResponse,
  GetImportJobRequest,
  DeleteEmailTemplateRequest,
  ListCustomVerificationEmailTemplatesRequest,
  PutConfigurationSetDeliveryOptionsResponse,
  UntagResourceRequest,
  DeleteEmailIdentityResponse,
  GetSuppressedDestinationRequest,
  ListContactsRequest,
  PutDedicatedIpInPoolRequest,
  GetDeliverabilityDashboardOptionsRequest,
  PutConfigurationSetReputationOptionsRequest,
  CreateDeliverabilityTestReportResponse,
  PutDedicatedIpInPoolResponse,
  DeleteConfigurationSetEventDestinationRequest,
  PutConfigurationSetVdmOptionsRequest,
  CreateEmailIdentityResponse,
  DeleteEmailIdentityPolicyRequest,
  PutAccountSendingAttributesResponse,
  GetConfigurationSetResponse,
  CreateEmailTemplateRequest,
  ListDomainDeliverabilityCampaignsRequest,
  CreateDedicatedIpPoolRequest,
  BatchGetMetricDataResponse,
  PutConfigurationSetSendingOptionsResponse,
  SendCustomVerificationEmailRequest,
  PutEmailIdentityMailFromAttributesResponse,
  GetContactListRequest,
  PutConfigurationSetReputationOptionsResponse,
  GetDeliverabilityTestReportRequest,
  CustomVerificationEmailTemplateMetadata,
  ListCustomVerificationEmailTemplatesResponse,
  PutConfigurationSetTrackingOptionsResponse,
  ListDeliverabilityTestReportsResponse,
  DeleteDedicatedIpPoolResponse,
  PutEmailIdentityMailFromAttributesRequest,
  CreateImportJobRequest,
  TagResourceResponse,
  CreateCustomVerificationEmailTemplateRequest,
  GetEmailTemplateResponse,
  PutAccountVdmAttributesResponse,
  PutDeliverabilityDashboardOptionResponse,
  ListRecommendationsResponse,
  UpdateEmailTemplateResponse,
  UpdateContactRequest,
  DeleteContactResponse,
  GetDeliverabilityTestReportResponse,
  TagResourceRequest,
  SendBulkEmailRequest,
  PutAccountDetailsResponse,
  GetCustomVerificationEmailTemplateRequest,
  GetDomainStatisticsReportResponse,
  DeleteEmailIdentityRequest
}
import zio.stream.ZStream
import zio.aws.sesv2.model.primitives.{ConfigurationSetName, PoolName}
import scala.jdk.CollectionConverters.*
trait SesV2 extends AspectSupport[SesV2] {
  val api: SesV2AsyncClient
  def updateContact(
      request: zio.aws.sesv2.model.UpdateContactRequest
  ): IO[AwsError, zio.aws.sesv2.model.UpdateContactResponse.ReadOnly]
  def sendBulkEmail(
      request: zio.aws.sesv2.model.SendBulkEmailRequest
  ): IO[AwsError, zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly]
  def putAccountDetails(
      request: zio.aws.sesv2.model.PutAccountDetailsRequest
  ): IO[AwsError, zio.aws.sesv2.model.PutAccountDetailsResponse.ReadOnly]
  def getConfigurationSet(
      request: zio.aws.sesv2.model.GetConfigurationSetRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetConfigurationSetResponse.ReadOnly]
  def deleteEmailIdentityPolicy(
      request: zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.ReadOnly
  ]
  def createContactList(
      request: zio.aws.sesv2.model.CreateContactListRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateContactListResponse.ReadOnly]
  def putEmailIdentityConfigurationSetAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.ReadOnly
  ]
  def getDomainDeliverabilityCampaign(
      request: zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
  ]
  def createConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.CreateConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def putConfigurationSetReputationOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
  ]
  def getContactList(
      request: zio.aws.sesv2.model.GetContactListRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetContactListResponse.ReadOnly]
  def deleteSuppressedDestination(
      request: zio.aws.sesv2.model.DeleteSuppressedDestinationRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.ReadOnly
  ]
  def putAccountSendingAttributes(
      request: zio.aws.sesv2.model.PutAccountSendingAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutAccountSendingAttributesResponse.ReadOnly
  ]
  def listEmailIdentities(
      request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.IdentityInfo.ReadOnly]
  def listEmailIdentitiesPaginated(
      request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly]
  def getEmailTemplate(
      request: zio.aws.sesv2.model.GetEmailTemplateRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly]
  def createEmailIdentity(
      request: zio.aws.sesv2.model.CreateEmailIdentityRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly]
  def listDedicatedIpPools(
      request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
  ): ZStream[Any, AwsError, PoolName]
  def listDedicatedIpPoolsPaginated(
      request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly]
  def createEmailTemplate(
      request: zio.aws.sesv2.model.CreateEmailTemplateRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateEmailTemplateResponse.ReadOnly]
  def putAccountDedicatedIpWarmupAttributes(
      request: zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
  ]
  def getConfigurationSetEventDestinations(
      request: zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
  ]
  def sendEmail(
      request: zio.aws.sesv2.model.SendEmailRequest
  ): IO[AwsError, zio.aws.sesv2.model.SendEmailResponse.ReadOnly]
  def getEmailIdentity(
      request: zio.aws.sesv2.model.GetEmailIdentityRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly]
  def putEmailIdentityDkimSigningAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly
  ]
  def putConfigurationSetTrackingOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
  ]
  def listImportJobs(
      request: zio.aws.sesv2.model.ListImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.ImportJobSummary.ReadOnly]
  def listImportJobsPaginated(
      request: zio.aws.sesv2.model.ListImportJobsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly]
  def createCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.ReadOnly
  ]
  def putConfigurationSetVdmOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetVdmOptionsResponse.ReadOnly
  ]
  def deleteEmailIdentity(
      request: zio.aws.sesv2.model.DeleteEmailIdentityRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteEmailIdentityResponse.ReadOnly]
  def deleteContact(
      request: zio.aws.sesv2.model.DeleteContactRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteContactResponse.ReadOnly]
  def getDeliverabilityDashboardOptions(
      request: zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
  ]
  def createContact(
      request: zio.aws.sesv2.model.CreateContactRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateContactResponse.ReadOnly]
  def getAccount(
      request: zio.aws.sesv2.model.GetAccountRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetAccountResponse.ReadOnly]
  def getDomainStatisticsReport(
      request: zio.aws.sesv2.model.GetDomainStatisticsReportRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly
  ]
  def listEmailTemplates(
      request: zio.aws.sesv2.model.ListEmailTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly]
  def listEmailTemplatesPaginated(
      request: zio.aws.sesv2.model.ListEmailTemplatesRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly]
  def listSuppressedDestinations(
      request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
  ]
  def listSuppressedDestinationsPaginated(
      request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly
  ]
  def updateEmailIdentityPolicy(
      request: zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.ReadOnly
  ]
  def putSuppressedDestination(
      request: zio.aws.sesv2.model.PutSuppressedDestinationRequest
  ): IO[AwsError, zio.aws.sesv2.model.PutSuppressedDestinationResponse.ReadOnly]
  def putAccountVdmAttributes(
      request: zio.aws.sesv2.model.PutAccountVdmAttributesRequest
  ): IO[AwsError, zio.aws.sesv2.model.PutAccountVdmAttributesResponse.ReadOnly]
  def listRecommendations(
      request: zio.aws.sesv2.model.ListRecommendationsRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.Recommendation.ReadOnly]
  def listRecommendationsPaginated(
      request: zio.aws.sesv2.model.ListRecommendationsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly]
  def putConfigurationSetSuppressionOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.ReadOnly
  ]
  def getDedicatedIps(
      request: zio.aws.sesv2.model.GetDedicatedIpsRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.DedicatedIp.ReadOnly]
  def getDedicatedIpsPaginated(
      request: zio.aws.sesv2.model.GetDedicatedIpsRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly]
  def createDeliverabilityTestReport(
      request: zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly
  ]
  def listDomainDeliverabilityCampaigns(
      request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
  ]
  def listDomainDeliverabilityCampaignsPaginated(
      request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
  ]
  def createImportJob(
      request: zio.aws.sesv2.model.CreateImportJobRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly]
  def getBlacklistReports(
      request: zio.aws.sesv2.model.GetBlacklistReportsRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly]
  def testRenderEmailTemplate(
      request: zio.aws.sesv2.model.TestRenderEmailTemplateRequest
  ): IO[AwsError, zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly]
  def listCustomVerificationEmailTemplates(
      request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
  ]
  def listCustomVerificationEmailTemplatesPaginated(
      request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
  ]
  def createEmailIdentityPolicy(
      request: zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.sesv2.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.sesv2.model.UntagResourceResponse.ReadOnly]
  def getDedicatedIpPool(
      request: zio.aws.sesv2.model.GetDedicatedIpPoolRequest
  ): IO[AwsError, ReadOnly]
  def createDedicatedIpPool(
      request: zio.aws.sesv2.model.CreateDedicatedIpPoolRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.ReadOnly]
  def listContactLists(
      request: zio.aws.sesv2.model.ListContactListsRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.ContactList.ReadOnly]
  def listContactListsPaginated(
      request: zio.aws.sesv2.model.ListContactListsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListContactListsResponse.ReadOnly]
  def updateCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.ReadOnly
  ]
  def batchGetMetricData(
      request: zio.aws.sesv2.model.BatchGetMetricDataRequest
  ): IO[AwsError, zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly]
  def deleteEmailTemplate(
      request: zio.aws.sesv2.model.DeleteEmailTemplateRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteEmailTemplateResponse.ReadOnly]
  def listConfigurationSets(
      request: zio.aws.sesv2.model.ListConfigurationSetsRequest
  ): ZStream[Any, AwsError, ConfigurationSetName]
  def listConfigurationSetsPaginated(
      request: zio.aws.sesv2.model.ListConfigurationSetsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListConfigurationSetsResponse.ReadOnly]
  def putEmailIdentityMailFromAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
  ]
  def putEmailIdentityFeedbackAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
  ]
  def updateContactList(
      request: zio.aws.sesv2.model.UpdateContactListRequest
  ): IO[AwsError, zio.aws.sesv2.model.UpdateContactListResponse.ReadOnly]
  def deleteCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.sesv2.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly]
  def deleteDedicatedIpPool(
      request: zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteDedicatedIpPoolResponse.ReadOnly]
  def getDedicatedIp(
      request: zio.aws.sesv2.model.GetDedicatedIpRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly]
  def updateEmailTemplate(
      request: zio.aws.sesv2.model.UpdateEmailTemplateRequest
  ): IO[AwsError, zio.aws.sesv2.model.UpdateEmailTemplateResponse.ReadOnly]
  def putDeliverabilityDashboardOption(
      request: zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.sesv2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.sesv2.model.TagResourceResponse.ReadOnly]
  def getEmailIdentityPolicies(
      request: zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly]
  def deleteConfigurationSet(
      request: zio.aws.sesv2.model.DeleteConfigurationSetRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteConfigurationSetResponse.ReadOnly]
  def createConfigurationSet(
      request: zio.aws.sesv2.model.CreateConfigurationSetRequest
  ): IO[AwsError, zio.aws.sesv2.model.CreateConfigurationSetResponse.ReadOnly]
  def listDeliverabilityTestReports(
      request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
  ]
  def listDeliverabilityTestReportsPaginated(
      request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly
  ]
  def getImportJob(
      request: zio.aws.sesv2.model.GetImportJobRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetImportJobResponse.ReadOnly]
  def getContact(
      request: zio.aws.sesv2.model.GetContactRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetContactResponse.ReadOnly]
  def listContacts(
      request: zio.aws.sesv2.model.ListContactsRequest
  ): ZStream[Any, AwsError, zio.aws.sesv2.model.Contact.ReadOnly]
  def listContactsPaginated(
      request: zio.aws.sesv2.model.ListContactsRequest
  ): IO[AwsError, zio.aws.sesv2.model.ListContactsResponse.ReadOnly]
  def updateConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def putDedicatedIpInPool(
      request: zio.aws.sesv2.model.PutDedicatedIpInPoolRequest
  ): IO[AwsError, zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.ReadOnly]
  def getCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
  ]
  def sendCustomVerificationEmail(
      request: zio.aws.sesv2.model.SendCustomVerificationEmailRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly
  ]
  def putConfigurationSetSendingOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
  ]
  def getSuppressedDestination(
      request: zio.aws.sesv2.model.GetSuppressedDestinationRequest
  ): IO[AwsError, zio.aws.sesv2.model.GetSuppressedDestinationResponse.ReadOnly]
  def putConfigurationSetDeliveryOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ]
  def getDeliverabilityTestReport(
      request: zio.aws.sesv2.model.GetDeliverabilityTestReportRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly
  ]
  def putAccountSuppressionAttributes(
      request: zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.ReadOnly
  ]
  def putDedicatedIpWarmupAttributes(
      request: zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
  ]
  def deleteConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def putEmailIdentityDkimAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest
  ): IO[
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
  ]
  def deleteContactList(
      request: zio.aws.sesv2.model.DeleteContactListRequest
  ): IO[AwsError, zio.aws.sesv2.model.DeleteContactListResponse.ReadOnly]
}
object SesV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SesV2] = customized(identity)
  def customized(
      customization: SesV2AsyncClientBuilder => SesV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SesV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SesV2AsyncClientBuilder => SesV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SesV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SesV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SesV2AsyncClient, SesV2AsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[SesV2AsyncClient, SesV2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SesV2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SesV2Impl[R](
      override val api: SesV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SesV2
      with AwsServiceBase[R] {
    override val serviceName: String = "SesV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SesV2Impl[R1] = new SesV2Impl(api, newAspect, r)
    def updateContact(
        request: zio.aws.sesv2.model.UpdateContactRequest
    ): IO[AwsError, zio.aws.sesv2.model.UpdateContactResponse.ReadOnly] =
      asyncRequestResponse[UpdateContactRequest, UpdateContactResponse](
        "updateContact",
        api.updateContact
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.UpdateContactResponse.wrap)
        .provideEnvironment(r)
    def sendBulkEmail(
        request: zio.aws.sesv2.model.SendBulkEmailRequest
    ): IO[AwsError, zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly] =
      asyncRequestResponse[SendBulkEmailRequest, SendBulkEmailResponse](
        "sendBulkEmail",
        api.sendBulkEmail
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.SendBulkEmailResponse.wrap)
        .provideEnvironment(r)
    def putAccountDetails(
        request: zio.aws.sesv2.model.PutAccountDetailsRequest
    ): IO[AwsError, zio.aws.sesv2.model.PutAccountDetailsResponse.ReadOnly] =
      asyncRequestResponse[PutAccountDetailsRequest, PutAccountDetailsResponse](
        "putAccountDetails",
        api.putAccountDetails
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.PutAccountDetailsResponse.wrap)
        .provideEnvironment(r)
    def getConfigurationSet(
        request: zio.aws.sesv2.model.GetConfigurationSetRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetConfigurationSetResponse.ReadOnly] =
      asyncRequestResponse[
        GetConfigurationSetRequest,
        GetConfigurationSetResponse
      ]("getConfigurationSet", api.getConfigurationSet)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetConfigurationSetResponse.wrap)
        .provideEnvironment(r)
    def deleteEmailIdentityPolicy(
        request: zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEmailIdentityPolicyRequest,
      DeleteEmailIdentityPolicyResponse
    ]("deleteEmailIdentityPolicy", api.deleteEmailIdentityPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.wrap)
      .provideEnvironment(r)
    def createContactList(
        request: zio.aws.sesv2.model.CreateContactListRequest
    ): IO[AwsError, zio.aws.sesv2.model.CreateContactListResponse.ReadOnly] =
      asyncRequestResponse[CreateContactListRequest, CreateContactListResponse](
        "createContactList",
        api.createContactList
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.CreateContactListResponse.wrap)
        .provideEnvironment(r)
    def putEmailIdentityConfigurationSetAttributes(
        request: zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityConfigurationSetAttributesRequest,
      PutEmailIdentityConfigurationSetAttributesResponse
    ](
      "putEmailIdentityConfigurationSetAttributes",
      api.putEmailIdentityConfigurationSetAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def getDomainDeliverabilityCampaign(
        request: zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainDeliverabilityCampaignRequest,
      GetDomainDeliverabilityCampaignResponse
    ]("getDomainDeliverabilityCampaign", api.getDomainDeliverabilityCampaign)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.wrap)
      .provideEnvironment(r)
    def createConfigurationSetEventDestination(
        request: zio.aws.sesv2.model.CreateConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateConfigurationSetEventDestinationRequest,
      CreateConfigurationSetEventDestinationResponse
    ](
      "createConfigurationSetEventDestination",
      api.createConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putConfigurationSetReputationOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetReputationOptionsRequest,
      PutConfigurationSetReputationOptionsResponse
    ](
      "putConfigurationSetReputationOptions",
      api.putConfigurationSetReputationOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def getContactList(
        request: zio.aws.sesv2.model.GetContactListRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetContactListResponse.ReadOnly] =
      asyncRequestResponse[GetContactListRequest, GetContactListResponse](
        "getContactList",
        api.getContactList
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetContactListResponse.wrap)
        .provideEnvironment(r)
    def deleteSuppressedDestination(
        request: zio.aws.sesv2.model.DeleteSuppressedDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSuppressedDestinationRequest,
      DeleteSuppressedDestinationResponse
    ]("deleteSuppressedDestination", api.deleteSuppressedDestination)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.wrap)
      .provideEnvironment(r)
    def putAccountSendingAttributes(
        request: zio.aws.sesv2.model.PutAccountSendingAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutAccountSendingAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountSendingAttributesRequest,
      PutAccountSendingAttributesResponse
    ]("putAccountSendingAttributes", api.putAccountSendingAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutAccountSendingAttributesResponse.wrap)
      .provideEnvironment(r)
    def listEmailIdentities(
        request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.IdentityInfo.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListEmailIdentitiesRequest,
        ListEmailIdentitiesResponse,
        IdentityInfo
      ](
        "listEmailIdentities",
        api.listEmailIdentities,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.emailIdentities().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.IdentityInfo.wrap(item))
        .provideEnvironment(r)
    def listEmailIdentitiesPaginated(
        request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly] =
      asyncRequestResponse[
        ListEmailIdentitiesRequest,
        ListEmailIdentitiesResponse
      ]("listEmailIdentities", api.listEmailIdentities)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListEmailIdentitiesResponse.wrap)
        .provideEnvironment(r)
    def getEmailTemplate(
        request: zio.aws.sesv2.model.GetEmailTemplateRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetEmailTemplateRequest, GetEmailTemplateResponse](
        "getEmailTemplate",
        api.getEmailTemplate
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetEmailTemplateResponse.wrap)
        .provideEnvironment(r)
    def createEmailIdentity(
        request: zio.aws.sesv2.model.CreateEmailIdentityRequest
    ): IO[AwsError, zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        CreateEmailIdentityRequest,
        CreateEmailIdentityResponse
      ]("createEmailIdentity", api.createEmailIdentity)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.CreateEmailIdentityResponse.wrap)
        .provideEnvironment(r)
    def listDedicatedIpPools(
        request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
    ): ZStream[Any, AwsError, PoolName] = asyncSimplePaginatedRequest[
      ListDedicatedIpPoolsRequest,
      ListDedicatedIpPoolsResponse,
      java.lang.String
    ](
      "listDedicatedIpPools",
      api.listDedicatedIpPools,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dedicatedIpPools().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sesv2.model.primitives.PoolName(item))
      .provideEnvironment(r)
    def listDedicatedIpPoolsPaginated(
        request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly] =
      asyncRequestResponse[
        ListDedicatedIpPoolsRequest,
        ListDedicatedIpPoolsResponse
      ]("listDedicatedIpPools", api.listDedicatedIpPools)(
        request.buildAwsValue()
      ).map(zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.wrap)
        .provideEnvironment(r)
    def createEmailTemplate(
        request: zio.aws.sesv2.model.CreateEmailTemplateRequest
    ): IO[AwsError, zio.aws.sesv2.model.CreateEmailTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        CreateEmailTemplateRequest,
        CreateEmailTemplateResponse
      ]("createEmailTemplate", api.createEmailTemplate)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.CreateEmailTemplateResponse.wrap)
        .provideEnvironment(r)
    def putAccountDedicatedIpWarmupAttributes(
        request: zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountDedicatedIpWarmupAttributesRequest,
      PutAccountDedicatedIpWarmupAttributesResponse
    ](
      "putAccountDedicatedIpWarmupAttributes",
      api.putAccountDedicatedIpWarmupAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def getConfigurationSetEventDestinations(
        request: zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetConfigurationSetEventDestinationsRequest,
      GetConfigurationSetEventDestinationsResponse
    ](
      "getConfigurationSetEventDestinations",
      api.getConfigurationSetEventDestinations
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.wrap
      )
      .provideEnvironment(r)
    def sendEmail(
        request: zio.aws.sesv2.model.SendEmailRequest
    ): IO[AwsError, zio.aws.sesv2.model.SendEmailResponse.ReadOnly] =
      asyncRequestResponse[SendEmailRequest, SendEmailResponse](
        "sendEmail",
        api.sendEmail
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.SendEmailResponse.wrap)
        .provideEnvironment(r)
    def getEmailIdentity(
        request: zio.aws.sesv2.model.GetEmailIdentityRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly] =
      asyncRequestResponse[GetEmailIdentityRequest, GetEmailIdentityResponse](
        "getEmailIdentity",
        api.getEmailIdentity
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetEmailIdentityResponse.wrap)
        .provideEnvironment(r)
    def putEmailIdentityDkimSigningAttributes(
        request: zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityDkimSigningAttributesRequest,
      PutEmailIdentityDkimSigningAttributesResponse
    ](
      "putEmailIdentityDkimSigningAttributes",
      api.putEmailIdentityDkimSigningAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def putConfigurationSetTrackingOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetTrackingOptionsRequest,
      PutConfigurationSetTrackingOptionsResponse
    ](
      "putConfigurationSetTrackingOptions",
      api.putConfigurationSetTrackingOptions
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.wrap)
      .provideEnvironment(r)
    def listImportJobs(
        request: zio.aws.sesv2.model.ListImportJobsRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.ImportJobSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListImportJobsRequest,
        ListImportJobsResponse,
        ImportJobSummary
      ](
        "listImportJobs",
        api.listImportJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.importJobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.ImportJobSummary.wrap(item))
        .provideEnvironment(r)
    def listImportJobsPaginated(
        request: zio.aws.sesv2.model.ListImportJobsRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly] =
      asyncRequestResponse[ListImportJobsRequest, ListImportJobsResponse](
        "listImportJobs",
        api.listImportJobs
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListImportJobsResponse.wrap)
        .provideEnvironment(r)
    def createCustomVerificationEmailTemplate(
        request: zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomVerificationEmailTemplateRequest,
      CreateCustomVerificationEmailTemplateResponse
    ](
      "createCustomVerificationEmailTemplate",
      api.createCustomVerificationEmailTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def putConfigurationSetVdmOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetVdmOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetVdmOptionsRequest,
      PutConfigurationSetVdmOptionsResponse
    ]("putConfigurationSetVdmOptions", api.putConfigurationSetVdmOptions)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutConfigurationSetVdmOptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteEmailIdentity(
        request: zio.aws.sesv2.model.DeleteEmailIdentityRequest
    ): IO[AwsError, zio.aws.sesv2.model.DeleteEmailIdentityResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteEmailIdentityRequest,
        DeleteEmailIdentityResponse
      ]("deleteEmailIdentity", api.deleteEmailIdentity)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.DeleteEmailIdentityResponse.wrap)
        .provideEnvironment(r)
    def deleteContact(
        request: zio.aws.sesv2.model.DeleteContactRequest
    ): IO[AwsError, zio.aws.sesv2.model.DeleteContactResponse.ReadOnly] =
      asyncRequestResponse[DeleteContactRequest, DeleteContactResponse](
        "deleteContact",
        api.deleteContact
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.DeleteContactResponse.wrap)
        .provideEnvironment(r)
    def getDeliverabilityDashboardOptions(
        request: zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDeliverabilityDashboardOptionsRequest,
      GetDeliverabilityDashboardOptionsResponse
    ](
      "getDeliverabilityDashboardOptions",
      api.getDeliverabilityDashboardOptions
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.wrap)
      .provideEnvironment(r)
    def createContact(
        request: zio.aws.sesv2.model.CreateContactRequest
    ): IO[AwsError, zio.aws.sesv2.model.CreateContactResponse.ReadOnly] =
      asyncRequestResponse[CreateContactRequest, CreateContactResponse](
        "createContact",
        api.createContact
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.CreateContactResponse.wrap)
        .provideEnvironment(r)
    def getAccount(
        request: zio.aws.sesv2.model.GetAccountRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetAccountResponse.ReadOnly] =
      asyncRequestResponse[GetAccountRequest, GetAccountResponse](
        "getAccount",
        api.getAccount
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetAccountResponse.wrap)
        .provideEnvironment(r)
    def getDomainStatisticsReport(
        request: zio.aws.sesv2.model.GetDomainStatisticsReportRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainStatisticsReportRequest,
      GetDomainStatisticsReportResponse
    ]("getDomainStatisticsReport", api.getDomainStatisticsReport)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.GetDomainStatisticsReportResponse.wrap)
      .provideEnvironment(r)
    def listEmailTemplates(
        request: zio.aws.sesv2.model.ListEmailTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListEmailTemplatesRequest,
      ListEmailTemplatesResponse,
      EmailTemplateMetadata
    ](
      "listEmailTemplates",
      api.listEmailTemplates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.templatesMetadata().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sesv2.model.EmailTemplateMetadata.wrap(item))
      .provideEnvironment(r)
    def listEmailTemplatesPaginated(
        request: zio.aws.sesv2.model.ListEmailTemplatesRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly] =
      asyncRequestResponse[
        ListEmailTemplatesRequest,
        ListEmailTemplatesResponse
      ]("listEmailTemplates", api.listEmailTemplates)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListEmailTemplatesResponse.wrap)
        .provideEnvironment(r)
    def listSuppressedDestinations(
        request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListSuppressedDestinationsRequest,
      ListSuppressedDestinationsResponse,
      SuppressedDestinationSummary
    ](
      "listSuppressedDestinations",
      api.listSuppressedDestinations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.suppressedDestinationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sesv2.model.SuppressedDestinationSummary.wrap(item))
      .provideEnvironment(r)
    def listSuppressedDestinationsPaginated(
        request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSuppressedDestinationsRequest,
      ListSuppressedDestinationsResponse
    ]("listSuppressedDestinations", api.listSuppressedDestinations)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.ListSuppressedDestinationsResponse.wrap)
      .provideEnvironment(r)
    def updateEmailIdentityPolicy(
        request: zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEmailIdentityPolicyRequest,
      UpdateEmailIdentityPolicyResponse
    ]("updateEmailIdentityPolicy", api.updateEmailIdentityPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.wrap)
      .provideEnvironment(r)
    def putSuppressedDestination(
        request: zio.aws.sesv2.model.PutSuppressedDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutSuppressedDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutSuppressedDestinationRequest,
      PutSuppressedDestinationResponse
    ]("putSuppressedDestination", api.putSuppressedDestination)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutSuppressedDestinationResponse.wrap)
      .provideEnvironment(r)
    def putAccountVdmAttributes(
        request: zio.aws.sesv2.model.PutAccountVdmAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutAccountVdmAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountVdmAttributesRequest,
      PutAccountVdmAttributesResponse
    ]("putAccountVdmAttributes", api.putAccountVdmAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutAccountVdmAttributesResponse.wrap)
      .provideEnvironment(r)
    def listRecommendations(
        request: zio.aws.sesv2.model.ListRecommendationsRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.Recommendation.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListRecommendationsRequest,
        ListRecommendationsResponse,
        Recommendation
      ](
        "listRecommendations",
        api.listRecommendations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.recommendations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.Recommendation.wrap(item))
        .provideEnvironment(r)
    def listRecommendationsPaginated(
        request: zio.aws.sesv2.model.ListRecommendationsRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly] =
      asyncRequestResponse[
        ListRecommendationsRequest,
        ListRecommendationsResponse
      ]("listRecommendations", api.listRecommendations)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListRecommendationsResponse.wrap)
        .provideEnvironment(r)
    def putConfigurationSetSuppressionOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetSuppressionOptionsRequest,
      PutConfigurationSetSuppressionOptionsResponse
    ](
      "putConfigurationSetSuppressionOptions",
      api.putConfigurationSetSuppressionOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def getDedicatedIps(
        request: zio.aws.sesv2.model.GetDedicatedIpsRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.DedicatedIp.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetDedicatedIpsRequest,
        GetDedicatedIpsResponse,
        DedicatedIp
      ](
        "getDedicatedIps",
        api.getDedicatedIps,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.dedicatedIps().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.DedicatedIp.wrap(item))
        .provideEnvironment(r)
    def getDedicatedIpsPaginated(
        request: zio.aws.sesv2.model.GetDedicatedIpsRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly] =
      asyncRequestResponse[GetDedicatedIpsRequest, GetDedicatedIpsResponse](
        "getDedicatedIps",
        api.getDedicatedIps
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetDedicatedIpsResponse.wrap)
        .provideEnvironment(r)
    def createDeliverabilityTestReport(
        request: zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDeliverabilityTestReportRequest,
      CreateDeliverabilityTestReportResponse
    ]("createDeliverabilityTestReport", api.createDeliverabilityTestReport)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.wrap)
      .provideEnvironment(r)
    def listDomainDeliverabilityCampaigns(
        request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDomainDeliverabilityCampaignsRequest,
      ListDomainDeliverabilityCampaignsResponse,
      DomainDeliverabilityCampaign
    ](
      "listDomainDeliverabilityCampaigns",
      api.listDomainDeliverabilityCampaigns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainDeliverabilityCampaigns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sesv2.model.DomainDeliverabilityCampaign.wrap(item))
      .provideEnvironment(r)
    def listDomainDeliverabilityCampaignsPaginated(
        request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDomainDeliverabilityCampaignsRequest,
      ListDomainDeliverabilityCampaignsResponse
    ](
      "listDomainDeliverabilityCampaigns",
      api.listDomainDeliverabilityCampaigns
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.wrap)
      .provideEnvironment(r)
    def createImportJob(
        request: zio.aws.sesv2.model.CreateImportJobRequest
    ): IO[AwsError, zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly] =
      asyncRequestResponse[CreateImportJobRequest, CreateImportJobResponse](
        "createImportJob",
        api.createImportJob
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.CreateImportJobResponse.wrap)
        .provideEnvironment(r)
    def getBlacklistReports(
        request: zio.aws.sesv2.model.GetBlacklistReportsRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly] =
      asyncRequestResponse[
        GetBlacklistReportsRequest,
        GetBlacklistReportsResponse
      ]("getBlacklistReports", api.getBlacklistReports)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetBlacklistReportsResponse.wrap)
        .provideEnvironment(r)
    def testRenderEmailTemplate(
        request: zio.aws.sesv2.model.TestRenderEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      TestRenderEmailTemplateRequest,
      TestRenderEmailTemplateResponse
    ]("testRenderEmailTemplate", api.testRenderEmailTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.TestRenderEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def listCustomVerificationEmailTemplates(
        request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListCustomVerificationEmailTemplatesRequest,
      ListCustomVerificationEmailTemplatesResponse,
      CustomVerificationEmailTemplateMetadata
    ](
      "listCustomVerificationEmailTemplates",
      api.listCustomVerificationEmailTemplates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.customVerificationEmailTemplates().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.wrap(item)
      )
      .provideEnvironment(r)
    def listCustomVerificationEmailTemplatesPaginated(
        request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCustomVerificationEmailTemplatesRequest,
      ListCustomVerificationEmailTemplatesResponse
    ](
      "listCustomVerificationEmailTemplates",
      api.listCustomVerificationEmailTemplates
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.wrap
      )
      .provideEnvironment(r)
    def createEmailIdentityPolicy(
        request: zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEmailIdentityPolicyRequest,
      CreateEmailIdentityPolicyResponse
    ]("createEmailIdentityPolicy", api.createEmailIdentityPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.sesv2.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.sesv2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getDedicatedIpPool(
        request: zio.aws.sesv2.model.GetDedicatedIpPoolRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetDedicatedIpPoolRequest,
      GetDedicatedIpPoolResponse
    ]("getDedicatedIpPool", api.getDedicatedIpPool)(request.buildAwsValue())
      .map(zio.aws.sesv2.model.GetDedicatedIpPoolResponse.wrap)
      .provideEnvironment(r)
    def createDedicatedIpPool(
        request: zio.aws.sesv2.model.CreateDedicatedIpPoolRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDedicatedIpPoolRequest,
      CreateDedicatedIpPoolResponse
    ]("createDedicatedIpPool", api.createDedicatedIpPool)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.wrap)
      .provideEnvironment(r)
    def listContactLists(
        request: zio.aws.sesv2.model.ListContactListsRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.ContactList.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListContactListsRequest,
        ListContactListsResponse,
        ContactList
      ](
        "listContactLists",
        api.listContactLists,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.contactLists().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.ContactList.wrap(item))
        .provideEnvironment(r)
    def listContactListsPaginated(
        request: zio.aws.sesv2.model.ListContactListsRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListContactListsResponse.ReadOnly] =
      asyncRequestResponse[ListContactListsRequest, ListContactListsResponse](
        "listContactLists",
        api.listContactLists
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListContactListsResponse.wrap)
        .provideEnvironment(r)
    def updateCustomVerificationEmailTemplate(
        request: zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateCustomVerificationEmailTemplateRequest,
      UpdateCustomVerificationEmailTemplateResponse
    ](
      "updateCustomVerificationEmailTemplate",
      api.updateCustomVerificationEmailTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def batchGetMetricData(
        request: zio.aws.sesv2.model.BatchGetMetricDataRequest
    ): IO[AwsError, zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly] =
      asyncRequestResponse[
        BatchGetMetricDataRequest,
        BatchGetMetricDataResponse
      ]("batchGetMetricData", api.batchGetMetricData)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.BatchGetMetricDataResponse.wrap)
        .provideEnvironment(r)
    def deleteEmailTemplate(
        request: zio.aws.sesv2.model.DeleteEmailTemplateRequest
    ): IO[AwsError, zio.aws.sesv2.model.DeleteEmailTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteEmailTemplateRequest,
        DeleteEmailTemplateResponse
      ]("deleteEmailTemplate", api.deleteEmailTemplate)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.DeleteEmailTemplateResponse.wrap)
        .provideEnvironment(r)
    def listConfigurationSets(
        request: zio.aws.sesv2.model.ListConfigurationSetsRequest
    ): ZStream[Any, AwsError, ConfigurationSetName] =
      asyncSimplePaginatedRequest[
        ListConfigurationSetsRequest,
        ListConfigurationSetsResponse,
        java.lang.String
      ](
        "listConfigurationSets",
        api.listConfigurationSets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.configurationSets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.primitives.ConfigurationSetName(item))
        .provideEnvironment(r)
    def listConfigurationSetsPaginated(
        request: zio.aws.sesv2.model.ListConfigurationSetsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.ListConfigurationSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListConfigurationSetsRequest,
      ListConfigurationSetsResponse
    ]("listConfigurationSets", api.listConfigurationSets)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.ListConfigurationSetsResponse.wrap)
      .provideEnvironment(r)
    def putEmailIdentityMailFromAttributes(
        request: zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityMailFromAttributesRequest,
      PutEmailIdentityMailFromAttributesResponse
    ](
      "putEmailIdentityMailFromAttributes",
      api.putEmailIdentityMailFromAttributes
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.wrap)
      .provideEnvironment(r)
    def putEmailIdentityFeedbackAttributes(
        request: zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityFeedbackAttributesRequest,
      PutEmailIdentityFeedbackAttributesResponse
    ](
      "putEmailIdentityFeedbackAttributes",
      api.putEmailIdentityFeedbackAttributes
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.wrap)
      .provideEnvironment(r)
    def updateContactList(
        request: zio.aws.sesv2.model.UpdateContactListRequest
    ): IO[AwsError, zio.aws.sesv2.model.UpdateContactListResponse.ReadOnly] =
      asyncRequestResponse[UpdateContactListRequest, UpdateContactListResponse](
        "updateContactList",
        api.updateContactList
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.UpdateContactListResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomVerificationEmailTemplate(
        request: zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCustomVerificationEmailTemplateRequest,
      DeleteCustomVerificationEmailTemplateResponse
    ](
      "deleteCustomVerificationEmailTemplate",
      api.deleteCustomVerificationEmailTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.sesv2.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDedicatedIpPool(
        request: zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteDedicatedIpPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDedicatedIpPoolRequest,
      DeleteDedicatedIpPoolResponse
    ]("deleteDedicatedIpPool", api.deleteDedicatedIpPool)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.DeleteDedicatedIpPoolResponse.wrap)
      .provideEnvironment(r)
    def getDedicatedIp(
        request: zio.aws.sesv2.model.GetDedicatedIpRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly] =
      asyncRequestResponse[GetDedicatedIpRequest, GetDedicatedIpResponse](
        "getDedicatedIp",
        api.getDedicatedIp
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetDedicatedIpResponse.wrap)
        .provideEnvironment(r)
    def updateEmailTemplate(
        request: zio.aws.sesv2.model.UpdateEmailTemplateRequest
    ): IO[AwsError, zio.aws.sesv2.model.UpdateEmailTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateEmailTemplateRequest,
        UpdateEmailTemplateResponse
      ]("updateEmailTemplate", api.updateEmailTemplate)(request.buildAwsValue())
        .map(zio.aws.sesv2.model.UpdateEmailTemplateResponse.wrap)
        .provideEnvironment(r)
    def putDeliverabilityDashboardOption(
        request: zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDeliverabilityDashboardOptionRequest,
      PutDeliverabilityDashboardOptionResponse
    ]("putDeliverabilityDashboardOption", api.putDeliverabilityDashboardOption)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.sesv2.model.TagResourceRequest
    ): IO[AwsError, zio.aws.sesv2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getEmailIdentityPolicies(
        request: zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetEmailIdentityPoliciesRequest,
      GetEmailIdentityPoliciesResponse
    ]("getEmailIdentityPolicies", api.getEmailIdentityPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationSet(
        request: zio.aws.sesv2.model.DeleteConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteConfigurationSetRequest,
      DeleteConfigurationSetResponse
    ]("deleteConfigurationSet", api.deleteConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.DeleteConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def createConfigurationSet(
        request: zio.aws.sesv2.model.CreateConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.CreateConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateConfigurationSetRequest,
      CreateConfigurationSetResponse
    ]("createConfigurationSet", api.createConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.CreateConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def listDeliverabilityTestReports(
        request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDeliverabilityTestReportsRequest,
      ListDeliverabilityTestReportsResponse,
      DeliverabilityTestReport
    ](
      "listDeliverabilityTestReports",
      api.listDeliverabilityTestReports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.deliverabilityTestReports().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.sesv2.model.DeliverabilityTestReport.wrap(item))
      .provideEnvironment(r)
    def listDeliverabilityTestReportsPaginated(
        request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDeliverabilityTestReportsRequest,
      ListDeliverabilityTestReportsResponse
    ]("listDeliverabilityTestReports", api.listDeliverabilityTestReports)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.wrap)
      .provideEnvironment(r)
    def getImportJob(
        request: zio.aws.sesv2.model.GetImportJobRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetImportJobResponse.ReadOnly] =
      asyncRequestResponse[GetImportJobRequest, GetImportJobResponse](
        "getImportJob",
        api.getImportJob
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetImportJobResponse.wrap)
        .provideEnvironment(r)
    def getContact(
        request: zio.aws.sesv2.model.GetContactRequest
    ): IO[AwsError, zio.aws.sesv2.model.GetContactResponse.ReadOnly] =
      asyncRequestResponse[GetContactRequest, GetContactResponse](
        "getContact",
        api.getContact
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.GetContactResponse.wrap)
        .provideEnvironment(r)
    def listContacts(
        request: zio.aws.sesv2.model.ListContactsRequest
    ): ZStream[Any, AwsError, zio.aws.sesv2.model.Contact.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListContactsRequest,
        ListContactsResponse,
        Contact
      ](
        "listContacts",
        api.listContacts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.contacts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.sesv2.model.Contact.wrap(item))
        .provideEnvironment(r)
    def listContactsPaginated(
        request: zio.aws.sesv2.model.ListContactsRequest
    ): IO[AwsError, zio.aws.sesv2.model.ListContactsResponse.ReadOnly] =
      asyncRequestResponse[ListContactsRequest, ListContactsResponse](
        "listContacts",
        api.listContacts
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.ListContactsResponse.wrap)
        .provideEnvironment(r)
    def updateConfigurationSetEventDestination(
        request: zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateConfigurationSetEventDestinationRequest,
      UpdateConfigurationSetEventDestinationResponse
    ](
      "updateConfigurationSetEventDestination",
      api.updateConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putDedicatedIpInPool(
        request: zio.aws.sesv2.model.PutDedicatedIpInPoolRequest
    ): IO[AwsError, zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.ReadOnly] =
      asyncRequestResponse[
        PutDedicatedIpInPoolRequest,
        PutDedicatedIpInPoolResponse
      ]("putDedicatedIpInPool", api.putDedicatedIpInPool)(
        request.buildAwsValue()
      ).map(zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.wrap)
        .provideEnvironment(r)
    def getCustomVerificationEmailTemplate(
        request: zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCustomVerificationEmailTemplateRequest,
      GetCustomVerificationEmailTemplateResponse
    ](
      "getCustomVerificationEmailTemplate",
      api.getCustomVerificationEmailTemplate
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.wrap)
      .provideEnvironment(r)
    def sendCustomVerificationEmail(
        request: zio.aws.sesv2.model.SendCustomVerificationEmailRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly
    ] = asyncRequestResponse[
      SendCustomVerificationEmailRequest,
      SendCustomVerificationEmailResponse
    ]("sendCustomVerificationEmail", api.sendCustomVerificationEmail)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.SendCustomVerificationEmailResponse.wrap)
      .provideEnvironment(r)
    def putConfigurationSetSendingOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetSendingOptionsRequest,
      PutConfigurationSetSendingOptionsResponse
    ](
      "putConfigurationSetSendingOptions",
      api.putConfigurationSetSendingOptions
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.wrap)
      .provideEnvironment(r)
    def getSuppressedDestination(
        request: zio.aws.sesv2.model.GetSuppressedDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetSuppressedDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSuppressedDestinationRequest,
      GetSuppressedDestinationResponse
    ]("getSuppressedDestination", api.getSuppressedDestination)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.GetSuppressedDestinationResponse.wrap)
      .provideEnvironment(r)
    def putConfigurationSetDeliveryOptions(
        request: zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetDeliveryOptionsRequest,
      PutConfigurationSetDeliveryOptionsResponse
    ](
      "putConfigurationSetDeliveryOptions",
      api.putConfigurationSetDeliveryOptions
    )(request.buildAwsValue())
      .map(zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.wrap)
      .provideEnvironment(r)
    def getDeliverabilityTestReport(
        request: zio.aws.sesv2.model.GetDeliverabilityTestReportRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDeliverabilityTestReportRequest,
      GetDeliverabilityTestReportResponse
    ]("getDeliverabilityTestReport", api.getDeliverabilityTestReport)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.wrap)
      .provideEnvironment(r)
    def putAccountSuppressionAttributes(
        request: zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountSuppressionAttributesRequest,
      PutAccountSuppressionAttributesResponse
    ]("putAccountSuppressionAttributes", api.putAccountSuppressionAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.wrap)
      .provideEnvironment(r)
    def putDedicatedIpWarmupAttributes(
        request: zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDedicatedIpWarmupAttributesRequest,
      PutDedicatedIpWarmupAttributesResponse
    ]("putDedicatedIpWarmupAttributes", api.putDedicatedIpWarmupAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationSetEventDestination(
        request: zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteConfigurationSetEventDestinationRequest,
      DeleteConfigurationSetEventDestinationResponse
    ](
      "deleteConfigurationSetEventDestination",
      api.deleteConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putEmailIdentityDkimAttributes(
        request: zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest
    ): IO[
      AwsError,
      zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityDkimAttributesRequest,
      PutEmailIdentityDkimAttributesResponse
    ]("putEmailIdentityDkimAttributes", api.putEmailIdentityDkimAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.wrap)
      .provideEnvironment(r)
    def deleteContactList(
        request: zio.aws.sesv2.model.DeleteContactListRequest
    ): IO[AwsError, zio.aws.sesv2.model.DeleteContactListResponse.ReadOnly] =
      asyncRequestResponse[DeleteContactListRequest, DeleteContactListResponse](
        "deleteContactList",
        api.deleteContactList
      )(request.buildAwsValue())
        .map(zio.aws.sesv2.model.DeleteContactListResponse.wrap)
        .provideEnvironment(r)
  }
  def updateContact(request: zio.aws.sesv2.model.UpdateContactRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContact(request))
  def sendBulkEmail(request: zio.aws.sesv2.model.SendBulkEmailRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendBulkEmail(request))
  def putAccountDetails(
      request: zio.aws.sesv2.model.PutAccountDetailsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutAccountDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountDetails(request))
  def getConfigurationSet(
      request: zio.aws.sesv2.model.GetConfigurationSetRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfigurationSet(request))
  def deleteEmailIdentityPolicy(
      request: zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailIdentityPolicy(request))
  def createContactList(
      request: zio.aws.sesv2.model.CreateContactListRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateContactListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContactList(request))
  def putEmailIdentityConfigurationSetAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityConfigurationSetAttributes(request))
  def getDomainDeliverabilityCampaign(
      request: zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainDeliverabilityCampaign(request))
  def createConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.CreateConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSetEventDestination(request))
  def putConfigurationSetReputationOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetReputationOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetReputationOptions(request))
  def getContactList(request: zio.aws.sesv2.model.GetContactListRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetContactListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContactList(request))
  def deleteSuppressedDestination(
      request: zio.aws.sesv2.model.DeleteSuppressedDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSuppressedDestination(request))
  def putAccountSendingAttributes(
      request: zio.aws.sesv2.model.PutAccountSendingAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutAccountSendingAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountSendingAttributes(request))
  def listEmailIdentities(
      request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.IdentityInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listEmailIdentities(request))
  def listEmailIdentitiesPaginated(
      request: zio.aws.sesv2.model.ListEmailIdentitiesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEmailIdentitiesPaginated(request))
  def getEmailTemplate(
      request: zio.aws.sesv2.model.GetEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailTemplate(request))
  def createEmailIdentity(
      request: zio.aws.sesv2.model.CreateEmailIdentityRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEmailIdentity(request))
  def listDedicatedIpPools(
      request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
  ): ZStream[zio.aws.sesv2.SesV2, AwsError, PoolName] =
    ZStream.serviceWithStream(_.listDedicatedIpPools(request))
  def listDedicatedIpPoolsPaginated(
      request: zio.aws.sesv2.model.ListDedicatedIpPoolsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDedicatedIpPoolsPaginated(request))
  def createEmailTemplate(
      request: zio.aws.sesv2.model.CreateEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEmailTemplate(request))
  def putAccountDedicatedIpWarmupAttributes(
      request: zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountDedicatedIpWarmupAttributes(request))
  def getConfigurationSetEventDestinations(
      request: zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfigurationSetEventDestinations(request))
  def sendEmail(request: zio.aws.sesv2.model.SendEmailRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.SendEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendEmail(request))
  def getEmailIdentity(
      request: zio.aws.sesv2.model.GetEmailIdentityRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailIdentity(request))
  def putEmailIdentityDkimSigningAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityDkimSigningAttributes(request))
  def putConfigurationSetTrackingOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetTrackingOptions(request))
  def listImportJobs(
      request: zio.aws.sesv2.model.ListImportJobsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ImportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImportJobs(request))
  def listImportJobsPaginated(
      request: zio.aws.sesv2.model.ListImportJobsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImportJobsPaginated(request))
  def createCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomVerificationEmailTemplate(request))
  def putConfigurationSetVdmOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetVdmOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetVdmOptions(request))
  def deleteEmailIdentity(
      request: zio.aws.sesv2.model.DeleteEmailIdentityRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailIdentity(request))
  def deleteContact(request: zio.aws.sesv2.model.DeleteContactRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContact(request))
  def getDeliverabilityDashboardOptions(
      request: zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeliverabilityDashboardOptions(request))
  def createContact(request: zio.aws.sesv2.model.CreateContactRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContact(request))
  def getAccount(request: zio.aws.sesv2.model.GetAccountRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccount(request))
  def getDomainStatisticsReport(
      request: zio.aws.sesv2.model.GetDomainStatisticsReportRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainStatisticsReport(request))
  def listEmailTemplates(
      request: zio.aws.sesv2.model.ListEmailTemplatesRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listEmailTemplates(request))
  def listEmailTemplatesPaginated(
      request: zio.aws.sesv2.model.ListEmailTemplatesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEmailTemplatesPaginated(request))
  def listSuppressedDestinations(
      request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSuppressedDestinations(request))
  def listSuppressedDestinationsPaginated(
      request: zio.aws.sesv2.model.ListSuppressedDestinationsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSuppressedDestinationsPaginated(request))
  def updateEmailIdentityPolicy(
      request: zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEmailIdentityPolicy(request))
  def putSuppressedDestination(
      request: zio.aws.sesv2.model.PutSuppressedDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutSuppressedDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSuppressedDestination(request))
  def putAccountVdmAttributes(
      request: zio.aws.sesv2.model.PutAccountVdmAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutAccountVdmAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountVdmAttributes(request))
  def listRecommendations(
      request: zio.aws.sesv2.model.ListRecommendationsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.Recommendation.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecommendations(request))
  def listRecommendationsPaginated(
      request: zio.aws.sesv2.model.ListRecommendationsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendationsPaginated(request))
  def putConfigurationSetSuppressionOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetSuppressionOptions(request))
  def getDedicatedIps(
      request: zio.aws.sesv2.model.GetDedicatedIpsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DedicatedIp.ReadOnly
  ] = ZStream.serviceWithStream(_.getDedicatedIps(request))
  def getDedicatedIpsPaginated(
      request: zio.aws.sesv2.model.GetDedicatedIpsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDedicatedIpsPaginated(request))
  def createDeliverabilityTestReport(
      request: zio.aws.sesv2.model.CreateDeliverabilityTestReportRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeliverabilityTestReport(request))
  def listDomainDeliverabilityCampaigns(
      request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomainDeliverabilityCampaigns(request))
  def listDomainDeliverabilityCampaignsPaginated(
      request: zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainDeliverabilityCampaignsPaginated(request))
  def createImportJob(request: zio.aws.sesv2.model.CreateImportJobRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImportJob(request))
  def getBlacklistReports(
      request: zio.aws.sesv2.model.GetBlacklistReportsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlacklistReports(request))
  def testRenderEmailTemplate(
      request: zio.aws.sesv2.model.TestRenderEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testRenderEmailTemplate(request))
  def listCustomVerificationEmailTemplates(
      request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomVerificationEmailTemplates(request))
  def listCustomVerificationEmailTemplatesPaginated(
      request: zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listCustomVerificationEmailTemplatesPaginated(request))
  def createEmailIdentityPolicy(
      request: zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEmailIdentityPolicy(request))
  def untagResource(request: zio.aws.sesv2.model.UntagResourceRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getDedicatedIpPool(
      request: zio.aws.sesv2.model.GetDedicatedIpPoolRequest
  ): ZIO[zio.aws.sesv2.SesV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getDedicatedIpPool(request))
  def createDedicatedIpPool(
      request: zio.aws.sesv2.model.CreateDedicatedIpPoolRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDedicatedIpPool(request))
  def listContactLists(
      request: zio.aws.sesv2.model.ListContactListsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ContactList.ReadOnly
  ] = ZStream.serviceWithStream(_.listContactLists(request))
  def listContactListsPaginated(
      request: zio.aws.sesv2.model.ListContactListsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListContactListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactListsPaginated(request))
  def updateCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomVerificationEmailTemplate(request))
  def batchGetMetricData(
      request: zio.aws.sesv2.model.BatchGetMetricDataRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetMetricData(request))
  def deleteEmailTemplate(
      request: zio.aws.sesv2.model.DeleteEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailTemplate(request))
  def listConfigurationSets(
      request: zio.aws.sesv2.model.ListConfigurationSetsRequest
  ): ZStream[zio.aws.sesv2.SesV2, AwsError, ConfigurationSetName] =
    ZStream.serviceWithStream(_.listConfigurationSets(request))
  def listConfigurationSetsPaginated(
      request: zio.aws.sesv2.model.ListConfigurationSetsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListConfigurationSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationSetsPaginated(request))
  def putEmailIdentityMailFromAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityMailFromAttributes(request))
  def putEmailIdentityFeedbackAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityFeedbackAttributes(request))
  def updateContactList(
      request: zio.aws.sesv2.model.UpdateContactListRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateContactListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContactList(request))
  def deleteCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomVerificationEmailTemplate(request))
  def listTagsForResource(
      request: zio.aws.sesv2.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteDedicatedIpPool(
      request: zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteDedicatedIpPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDedicatedIpPool(request))
  def getDedicatedIp(request: zio.aws.sesv2.model.GetDedicatedIpRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDedicatedIp(request))
  def updateEmailTemplate(
      request: zio.aws.sesv2.model.UpdateEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEmailTemplate(request))
  def putDeliverabilityDashboardOption(
      request: zio.aws.sesv2.model.PutDeliverabilityDashboardOptionRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDeliverabilityDashboardOption(request))
  def tagResource(request: zio.aws.sesv2.model.TagResourceRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getEmailIdentityPolicies(
      request: zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailIdentityPolicies(request))
  def deleteConfigurationSet(
      request: zio.aws.sesv2.model.DeleteConfigurationSetRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSet(request))
  def createConfigurationSet(
      request: zio.aws.sesv2.model.CreateConfigurationSetRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.CreateConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSet(request))
  def listDeliverabilityTestReports(
      request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
  ): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeliverabilityTestReports(request))
  def listDeliverabilityTestReportsPaginated(
      request: zio.aws.sesv2.model.ListDeliverabilityTestReportsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeliverabilityTestReportsPaginated(request))
  def getImportJob(request: zio.aws.sesv2.model.GetImportJobRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImportJob(request))
  def getContact(request: zio.aws.sesv2.model.GetContactRequest): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContact(request))
  def listContacts(request: zio.aws.sesv2.model.ListContactsRequest): ZStream[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.Contact.ReadOnly
  ] = ZStream.serviceWithStream(_.listContacts(request))
  def listContactsPaginated(
      request: zio.aws.sesv2.model.ListContactsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.ListContactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContactsPaginated(request))
  def updateConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationSetEventDestination(request))
  def putDedicatedIpInPool(
      request: zio.aws.sesv2.model.PutDedicatedIpInPoolRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDedicatedIpInPool(request))
  def getCustomVerificationEmailTemplate(
      request: zio.aws.sesv2.model.GetCustomVerificationEmailTemplateRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomVerificationEmailTemplate(request))
  def sendCustomVerificationEmail(
      request: zio.aws.sesv2.model.SendCustomVerificationEmailRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendCustomVerificationEmail(request))
  def putConfigurationSetSendingOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetSendingOptions(request))
  def getSuppressedDestination(
      request: zio.aws.sesv2.model.GetSuppressedDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetSuppressedDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSuppressedDestination(request))
  def putConfigurationSetDeliveryOptions(
      request: zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetDeliveryOptions(request))
  def getDeliverabilityTestReport(
      request: zio.aws.sesv2.model.GetDeliverabilityTestReportRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeliverabilityTestReport(request))
  def putAccountSuppressionAttributes(
      request: zio.aws.sesv2.model.PutAccountSuppressionAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountSuppressionAttributes(request))
  def putDedicatedIpWarmupAttributes(
      request: zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDedicatedIpWarmupAttributes(request))
  def deleteConfigurationSetEventDestination(
      request: zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSetEventDestination(request))
  def putEmailIdentityDkimAttributes(
      request: zio.aws.sesv2.model.PutEmailIdentityDkimAttributesRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityDkimAttributes(request))
  def deleteContactList(
      request: zio.aws.sesv2.model.DeleteContactListRequest
  ): ZIO[
    zio.aws.sesv2.SesV2,
    AwsError,
    zio.aws.sesv2.model.DeleteContactListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContactList(request))
}
