package zio.aws.sesv2
import zio.aws.sesv2.model.primitives.Policy.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.sesv2.model.primitives.{
  EmailAddress,
  PoolName,
  AdditionalContactEmailAddress,
  BlacklistItemName,
  Counter,
  ConfigurationSetName,
  Ip,
  PolicyName,
  Timestamp,
  ListRecommendationFilterValue,
  Esp,
  Policy,
  DnsToken,
  IspName,
  MetricDimensionValue,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AdditionalContactEmailAddress extends Subtype[String]
    type AdditionalContactEmailAddress =
      zio.aws.sesv2.model.primitives.AdditionalContactEmailAddress.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.sesv2.model.primitives.AmazonResourceName.Type
    object AttributesData extends Subtype[String]
    type AttributesData = zio.aws.sesv2.model.primitives.AttributesData.Type
    object BlacklistItemName extends Subtype[String]
    type BlacklistItemName =
      zio.aws.sesv2.model.primitives.BlacklistItemName.Type
    object BlacklistingDescription extends Subtype[String]
    type BlacklistingDescription =
      zio.aws.sesv2.model.primitives.BlacklistingDescription.Type
    object CampaignId extends Subtype[String]
    type CampaignId = zio.aws.sesv2.model.primitives.CampaignId.Type
    object CaseId extends Subtype[String]
    type CaseId = zio.aws.sesv2.model.primitives.CaseId.Type
    object Charset extends Subtype[String]
    type Charset = zio.aws.sesv2.model.primitives.Charset.Type
    object ConfigurationSetName extends Subtype[String]
    type ConfigurationSetName =
      zio.aws.sesv2.model.primitives.ConfigurationSetName.Type
    object ContactListName extends Subtype[String]
    type ContactListName = zio.aws.sesv2.model.primitives.ContactListName.Type
    object Counter extends Subtype[Long]
    type Counter = zio.aws.sesv2.model.primitives.Counter.Type
    object CustomRedirectDomain extends Subtype[String]
    type CustomRedirectDomain =
      zio.aws.sesv2.model.primitives.CustomRedirectDomain.Type
    object DefaultDimensionValue extends Subtype[String]
    type DefaultDimensionValue =
      zio.aws.sesv2.model.primitives.DefaultDimensionValue.Type
    object DeliverabilityTestSubject extends Subtype[String]
    type DeliverabilityTestSubject =
      zio.aws.sesv2.model.primitives.DeliverabilityTestSubject.Type
    object Description extends Subtype[String]
    type Description = zio.aws.sesv2.model.primitives.Description.Type
    object DimensionName extends Subtype[String]
    type DimensionName = zio.aws.sesv2.model.primitives.DimensionName.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.sesv2.model.primitives.DisplayName.Type
    object DnsToken extends Subtype[String]
    type DnsToken = zio.aws.sesv2.model.primitives.DnsToken.Type
    object Domain extends Subtype[String]
    type Domain = zio.aws.sesv2.model.primitives.Domain.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.sesv2.model.primitives.EmailAddress.Type
    object EmailTemplateData extends Subtype[String]
    type EmailTemplateData =
      zio.aws.sesv2.model.primitives.EmailTemplateData.Type
    object EmailTemplateHtml extends Subtype[String]
    type EmailTemplateHtml =
      zio.aws.sesv2.model.primitives.EmailTemplateHtml.Type
    object EmailTemplateName extends Subtype[String]
    type EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName.Type
    object EmailTemplateSubject extends Subtype[String]
    type EmailTemplateSubject =
      zio.aws.sesv2.model.primitives.EmailTemplateSubject.Type
    object EmailTemplateText extends Subtype[String]
    type EmailTemplateText =
      zio.aws.sesv2.model.primitives.EmailTemplateText.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.sesv2.model.primitives.Enabled.Type
    object EnabledWrapper extends Subtype[Boolean]
    type EnabledWrapper = zio.aws.sesv2.model.primitives.EnabledWrapper.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.sesv2.model.primitives.ErrorMessage.Type
    object Esp extends Subtype[String]
    type Esp = zio.aws.sesv2.model.primitives.Esp.Type
    object EventDestinationName extends Subtype[String]
    type EventDestinationName =
      zio.aws.sesv2.model.primitives.EventDestinationName.Type
    object FailedRecordsCount extends Subtype[Int]
    type FailedRecordsCount =
      zio.aws.sesv2.model.primitives.FailedRecordsCount.Type
    object FailedRecordsS3Url extends Subtype[String]
    type FailedRecordsS3Url =
      zio.aws.sesv2.model.primitives.FailedRecordsS3Url.Type
    object FailureRedirectionURL extends Subtype[String]
    type FailureRedirectionURL =
      zio.aws.sesv2.model.primitives.FailureRedirectionURL.Type
    object FeedbackId extends Subtype[String]
    type FeedbackId = zio.aws.sesv2.model.primitives.FeedbackId.Type
    object GeneralEnforcementStatus extends Subtype[String]
    type GeneralEnforcementStatus =
      zio.aws.sesv2.model.primitives.GeneralEnforcementStatus.Type
    object Identity extends Subtype[String]
    type Identity = zio.aws.sesv2.model.primitives.Identity.Type
    object ImageUrl extends Subtype[String]
    type ImageUrl = zio.aws.sesv2.model.primitives.ImageUrl.Type
    object Ip extends Subtype[String]
    type Ip = zio.aws.sesv2.model.primitives.Ip.Type
    object IspName extends Subtype[String]
    type IspName = zio.aws.sesv2.model.primitives.IspName.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.sesv2.model.primitives.JobId.Type
    object LastFreshStart extends Subtype[Instant]
    type LastFreshStart = zio.aws.sesv2.model.primitives.LastFreshStart.Type
    object ListRecommendationFilterValue extends Subtype[String]
    type ListRecommendationFilterValue =
      zio.aws.sesv2.model.primitives.ListRecommendationFilterValue.Type
    object MailFromDomainName extends Subtype[String]
    type MailFromDomainName =
      zio.aws.sesv2.model.primitives.MailFromDomainName.Type
    object Max24HourSend extends Subtype[Double]
    type Max24HourSend = zio.aws.sesv2.model.primitives.Max24HourSend.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.sesv2.model.primitives.MaxItems.Type
    object MaxSendRate extends Subtype[Double]
    type MaxSendRate = zio.aws.sesv2.model.primitives.MaxSendRate.Type
    object MessageContent extends Subtype[String]
    type MessageContent = zio.aws.sesv2.model.primitives.MessageContent.Type
    object MessageData extends Subtype[String]
    type MessageData = zio.aws.sesv2.model.primitives.MessageData.Type
    object MessageTagName extends Subtype[String]
    type MessageTagName = zio.aws.sesv2.model.primitives.MessageTagName.Type
    object MessageTagValue extends Subtype[String]
    type MessageTagValue = zio.aws.sesv2.model.primitives.MessageTagValue.Type
    object MetricDimensionValue extends Subtype[String]
    type MetricDimensionValue =
      zio.aws.sesv2.model.primitives.MetricDimensionValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.sesv2.model.primitives.NextToken.Type
    object OutboundMessageId extends Subtype[String]
    type OutboundMessageId =
      zio.aws.sesv2.model.primitives.OutboundMessageId.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.sesv2.model.primitives.Percentage.Type
    object Percentage100Wrapper extends Subtype[Int]
    type Percentage100Wrapper =
      zio.aws.sesv2.model.primitives.Percentage100Wrapper.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.sesv2.model.primitives.Policy.Type
    object PolicyName extends Subtype[String]
    type PolicyName = zio.aws.sesv2.model.primitives.PolicyName.Type
    object PoolName extends Subtype[String]
    type PoolName = zio.aws.sesv2.model.primitives.PoolName.Type
    object PrivateKey extends Subtype[String]
    type PrivateKey = zio.aws.sesv2.model.primitives.PrivateKey.Type
    object ProcessedRecordsCount extends Subtype[Int]
    type ProcessedRecordsCount =
      zio.aws.sesv2.model.primitives.ProcessedRecordsCount.Type
    object QueryErrorMessage extends Subtype[String]
    type QueryErrorMessage =
      zio.aws.sesv2.model.primitives.QueryErrorMessage.Type
    object QueryIdentifier extends Subtype[String]
    type QueryIdentifier = zio.aws.sesv2.model.primitives.QueryIdentifier.Type
    object RawMessageData extends Subtype[Chunk[Byte]]
    type RawMessageData = zio.aws.sesv2.model.primitives.RawMessageData.Type
    object RblName extends Subtype[String]
    type RblName = zio.aws.sesv2.model.primitives.RblName.Type
    object RecommendationDescription extends Subtype[String]
    type RecommendationDescription =
      zio.aws.sesv2.model.primitives.RecommendationDescription.Type
    object RenderedEmailTemplate extends Subtype[String]
    type RenderedEmailTemplate =
      zio.aws.sesv2.model.primitives.RenderedEmailTemplate.Type
    object ReportId extends Subtype[String]
    type ReportId = zio.aws.sesv2.model.primitives.ReportId.Type
    object ReportName extends Subtype[String]
    type ReportName = zio.aws.sesv2.model.primitives.ReportName.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.sesv2.model.primitives.S3Url.Type
    object Selector extends Subtype[String]
    type Selector = zio.aws.sesv2.model.primitives.Selector.Type
    object SendingPoolName extends Subtype[String]
    type SendingPoolName = zio.aws.sesv2.model.primitives.SendingPoolName.Type
    object SentLast24Hours extends Subtype[Double]
    type SentLast24Hours = zio.aws.sesv2.model.primitives.SentLast24Hours.Type
    object Subject extends Subtype[String]
    type Subject = zio.aws.sesv2.model.primitives.Subject.Type
    object SuccessRedirectionURL extends Subtype[String]
    type SuccessRedirectionURL =
      zio.aws.sesv2.model.primitives.SuccessRedirectionURL.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.sesv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.sesv2.model.primitives.TagValue.Type
    object TemplateContent extends Subtype[String]
    type TemplateContent = zio.aws.sesv2.model.primitives.TemplateContent.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.sesv2.model.primitives.Timestamp.Type
    object TopicName extends Subtype[String]
    type TopicName = zio.aws.sesv2.model.primitives.TopicName.Type
    object UnsubscribeAll extends Subtype[Boolean]
    type UnsubscribeAll = zio.aws.sesv2.model.primitives.UnsubscribeAll.Type
    object UseCaseDescription extends Subtype[String]
    type UseCaseDescription =
      zio.aws.sesv2.model.primitives.UseCaseDescription.Type
    object UseDefaultIfPreferenceUnavailable extends Subtype[Boolean]
    type UseDefaultIfPreferenceUnavailable =
      zio.aws.sesv2.model.primitives.UseDefaultIfPreferenceUnavailable.Type
    object Volume extends Subtype[Long]
    type Volume = zio.aws.sesv2.model.primitives.Volume.Type
    object WebsiteURL extends Subtype[String]
    type WebsiteURL = zio.aws.sesv2.model.primitives.WebsiteURL.Type
  }
  type AdditionalContactEmailAddresses = List[AdditionalContactEmailAddress]
  type BatchGetMetricDataQueries =
    List[zio.aws.sesv2.model.BatchGetMetricDataQuery]
  type BlacklistEntries = List[zio.aws.sesv2.model.BlacklistEntry]
  type BlacklistItemNames = List[BlacklistItemName]
  type BlacklistReport =
    Map[BlacklistItemName, Iterable[zio.aws.sesv2.model.BlacklistEntry]]
  type BulkEmailEntryList = List[zio.aws.sesv2.model.BulkEmailEntry]
  type BulkEmailEntryResultList = List[zio.aws.sesv2.model.BulkEmailEntryResult]
  type CloudWatchDimensionConfigurations =
    List[zio.aws.sesv2.model.CloudWatchDimensionConfiguration]
  type ConfigurationSetNameList = List[ConfigurationSetName]
  type CustomVerificationEmailTemplatesList =
    List[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata]
  type DailyVolumes = List[zio.aws.sesv2.model.DailyVolume]
  type DedicatedIpList = List[zio.aws.sesv2.model.DedicatedIp]
  type DeliverabilityTestReports =
    List[zio.aws.sesv2.model.DeliverabilityTestReport]
  type Dimensions =
    Map[zio.aws.sesv2.model.MetricDimensionName, MetricDimensionValue]
  type DnsTokenList = List[DnsToken]
  type DomainDeliverabilityCampaignList =
    List[zio.aws.sesv2.model.DomainDeliverabilityCampaign]
  type DomainDeliverabilityTrackingOptions =
    List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption]
  type DomainIspPlacements = List[zio.aws.sesv2.model.DomainIspPlacement]
  type EmailAddressList = List[EmailAddress]
  type EmailTemplateMetadataList =
    List[zio.aws.sesv2.model.EmailTemplateMetadata]
  type Esps = List[Esp]
  type EventDestinations = List[zio.aws.sesv2.model.EventDestination]
  type EventTypes = List[zio.aws.sesv2.model.EventType]
  type IdentityInfoList = List[zio.aws.sesv2.model.IdentityInfo]
  type ImportJobSummaryList = List[zio.aws.sesv2.model.ImportJobSummary]
  type IpList = List[Ip]
  type IspNameList = List[IspName]
  type IspPlacements = List[zio.aws.sesv2.model.IspPlacement]
  type ListOfContactLists = List[zio.aws.sesv2.model.ContactList]
  type ListOfContacts = List[zio.aws.sesv2.model.Contact]
  type ListOfDedicatedIpPools = List[PoolName]
  type ListRecommendationsFilter = Map[
    zio.aws.sesv2.model.ListRecommendationsFilterKey,
    ListRecommendationFilterValue
  ]
  type MessageTagList = List[zio.aws.sesv2.model.MessageTag]
  type MetricDataErrorList = List[zio.aws.sesv2.model.MetricDataError]
  type MetricDataResultList = List[zio.aws.sesv2.model.MetricDataResult]
  type MetricValueList = List[Counter]
  type PolicyMap = Map[PolicyName, Policy]
  type RecommendationsList = List[zio.aws.sesv2.model.Recommendation]
  type SuppressedDestinationSummaries =
    List[zio.aws.sesv2.model.SuppressedDestinationSummary]
  type SuppressionListReasons = List[zio.aws.sesv2.model.SuppressionListReason]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.sesv2.model.Tag]
  type TimestampList = List[Timestamp]
  type TopicPreferenceList = List[zio.aws.sesv2.model.TopicPreference]
  type Topics = List[zio.aws.sesv2.model.Topic]
}
