package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Volume
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VolumeStatistics(
    inboxRawCount: Optional[Volume] = Optional.Absent,
    spamRawCount: Optional[Volume] = Optional.Absent,
    projectedInbox: Optional[Volume] = Optional.Absent,
    projectedSpam: Optional[Volume] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.VolumeStatistics = {
    import VolumeStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.VolumeStatistics
      .builder()
      .optionallyWith(
        inboxRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxRawCount)
      .optionallyWith(
        spamRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamRawCount)
      .optionallyWith(
        projectedInbox.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedInbox)
      .optionallyWith(
        projectedSpam.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedSpam)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.VolumeStatistics.ReadOnly =
    zio.aws.sesv2.model.VolumeStatistics.wrap(buildAwsValue())
}
object VolumeStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.VolumeStatistics =
      zio.aws.sesv2.model.VolumeStatistics(
        inboxRawCount.map(value => value),
        spamRawCount.map(value => value),
        projectedInbox.map(value => value),
        projectedSpam.map(value => value)
      )
    def inboxRawCount: Optional[Volume]
    def spamRawCount: Optional[Volume]
    def projectedInbox: Optional[Volume]
    def projectedSpam: Optional[Volume]
    def getInboxRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxRawCount", inboxRawCount)
    def getSpamRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamRawCount", spamRawCount)
    def getProjectedInbox: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedInbox", projectedInbox)
    def getProjectedSpam: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedSpam", projectedSpam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ) extends zio.aws.sesv2.model.VolumeStatistics.ReadOnly {
    override val inboxRawCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val spamRawCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.spamRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val projectedInbox: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedInbox())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val projectedSpam: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedSpam())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.VolumeStatistics
  ): zio.aws.sesv2.model.VolumeStatistics.ReadOnly = new Wrapper(impl)
}
