package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait WarmupStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.WarmupStatus
}
object WarmupStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.WarmupStatus
  ): zio.aws.sesv2.model.WarmupStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.WarmupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.WarmupStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.sesv2.model.WarmupStatus.DONE =>
      val r = DONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.WarmupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.WarmupStatus =
      software.amazon.awssdk.services.sesv2.model.WarmupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.sesv2.model.WarmupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.WarmupStatus =
      software.amazon.awssdk.services.sesv2.model.WarmupStatus.IN_PROGRESS
  }
  case object DONE extends zio.aws.sesv2.model.WarmupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.WarmupStatus =
      software.amazon.awssdk.services.sesv2.model.WarmupStatus.DONE
  }
}
