package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  EmailAddress
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendEmailRequest(
    fromEmailAddress: Optional[EmailAddress] = Optional.Absent,
    fromEmailAddressIdentityArn: Optional[AmazonResourceName] = Optional.Absent,
    destination: Optional[zio.aws.sesv2.model.Destination] = Optional.Absent,
    replyToAddresses: Optional[Iterable[EmailAddress]] = Optional.Absent,
    feedbackForwardingEmailAddress: Optional[EmailAddress] = Optional.Absent,
    feedbackForwardingEmailAddressIdentityArn: Optional[AmazonResourceName] =
      Optional.Absent,
    content: zio.aws.sesv2.model.EmailContent,
    emailTags: Optional[Iterable[zio.aws.sesv2.model.MessageTag]] =
      Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    listManagementOptions: Optional[zio.aws.sesv2.model.ListManagementOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendEmailRequest = {
    import SendEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendEmailRequest
      .builder()
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        fromEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddressIdentityArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        feedbackForwardingEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddress)
      .optionallyWith(
        feedbackForwardingEmailAddressIdentityArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddressIdentityArn)
      .content(content.buildAwsValue())
      .optionallyWith(
        emailTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emailTags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        listManagementOptions.map(value => value.buildAwsValue())
      )(_.listManagementOptions)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.SendEmailRequest.ReadOnly =
    zio.aws.sesv2.model.SendEmailRequest.wrap(buildAwsValue())
}
object SendEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendEmailRequest =
      zio.aws.sesv2.model.SendEmailRequest(
        fromEmailAddress.map(value => value),
        fromEmailAddressIdentityArn.map(value => value),
        destination.map(value => value.asEditable),
        replyToAddresses.map(value => value),
        feedbackForwardingEmailAddress.map(value => value),
        feedbackForwardingEmailAddressIdentityArn.map(value => value),
        content.asEditable,
        emailTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value),
        listManagementOptions.map(value => value.asEditable)
      )
    def fromEmailAddress: Optional[EmailAddress]
    def fromEmailAddressIdentityArn: Optional[AmazonResourceName]
    def destination: Optional[zio.aws.sesv2.model.Destination.ReadOnly]
    def replyToAddresses: Optional[List[EmailAddress]]
    def feedbackForwardingEmailAddress: Optional[EmailAddress]
    def feedbackForwardingEmailAddressIdentityArn: Optional[AmazonResourceName]
    def content: zio.aws.sesv2.model.EmailContent.ReadOnly
    def emailTags: Optional[List[zio.aws.sesv2.model.MessageTag.ReadOnly]]
    def configurationSetName: Optional[ConfigurationSetName]
    def listManagementOptions
        : Optional[zio.aws.sesv2.model.ListManagementOptions.ReadOnly]
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getFromEmailAddressIdentityArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField(
        "fromEmailAddressIdentityArn",
        fromEmailAddressIdentityArn
      )
    def getDestination
        : ZIO[Any, AwsError, zio.aws.sesv2.model.Destination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getReplyToAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getFeedbackForwardingEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField(
        "feedbackForwardingEmailAddress",
        feedbackForwardingEmailAddress
      )
    def getFeedbackForwardingEmailAddressIdentityArn
        : ZIO[Any, AwsError, AmazonResourceName] = AwsError.unwrapOptionField(
      "feedbackForwardingEmailAddressIdentityArn",
      feedbackForwardingEmailAddressIdentityArn
    )
    def getContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.EmailContent.ReadOnly] =
      ZIO.succeed(content)
    def getEmailTags
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("emailTags", emailTags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getListManagementOptions: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.ListManagementOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("listManagementOptions", listManagementOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ) extends zio.aws.sesv2.model.SendEmailRequest.ReadOnly {
    override val fromEmailAddress: Optional[EmailAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromEmailAddress())
        .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val fromEmailAddressIdentityArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromEmailAddressIdentityArn())
        .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val destination
        : Optional[zio.aws.sesv2.model.Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.sesv2.model.Destination.wrap(value))
    override val replyToAddresses: Optional[List[EmailAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replyToAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.primitives.EmailAddress(item)
          }.toList
        )
    override val feedbackForwardingEmailAddress: Optional[EmailAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.feedbackForwardingEmailAddress())
        .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val feedbackForwardingEmailAddressIdentityArn
        : Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackForwardingEmailAddressIdentityArn())
      .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val content: zio.aws.sesv2.model.EmailContent.ReadOnly =
      zio.aws.sesv2.model.EmailContent.wrap(impl.content())
    override val emailTags
        : Optional[List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.MessageTag.wrap(item)
          }.toList
        )
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.sesv2.model.primitives.ConfigurationSetName(value)
        )
    override val listManagementOptions
        : Optional[zio.aws.sesv2.model.ListManagementOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listManagementOptions())
        .map(value => zio.aws.sesv2.model.ListManagementOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendEmailRequest
  ): zio.aws.sesv2.model.SendEmailRequest.ReadOnly = new Wrapper(impl)
}
