package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait ScalingMode {
  def unwrap: software.amazon.awssdk.services.sesv2.model.ScalingMode
}
object ScalingMode {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.ScalingMode
  ): zio.aws.sesv2.model.ScalingMode = value match {
    case software.amazon.awssdk.services.sesv2.model.ScalingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.ScalingMode.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.sesv2.model.ScalingMode.MANAGED =>
      val r = MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.ScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ScalingMode =
      software.amazon.awssdk.services.sesv2.model.ScalingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.sesv2.model.ScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ScalingMode =
      software.amazon.awssdk.services.sesv2.model.ScalingMode.STANDARD
  }
  case object MANAGED extends zio.aws.sesv2.model.ScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ScalingMode =
      software.amazon.awssdk.services.sesv2.model.ScalingMode.MANAGED
  }
}
