package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Counter, Timestamp, QueryIdentifier}
import scala.jdk.CollectionConverters.*
final case class MetricDataResult(
    id: Optional[QueryIdentifier] = Optional.Absent,
    timestamps: Optional[Iterable[Timestamp]] = Optional.Absent,
    values: Optional[Iterable[Counter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.MetricDataResult = {
    import MetricDataResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.MetricDataResult
      .builder()
      .optionallyWith(
        id.map(value => QueryIdentifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            Counter.unwrap(item): java.lang.Long
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.MetricDataResult.ReadOnly =
    zio.aws.sesv2.model.MetricDataResult.wrap(buildAwsValue())
}
object MetricDataResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.MetricDataResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.MetricDataResult =
      zio.aws.sesv2.model.MetricDataResult(
        id.map(value => value),
        timestamps.map(value => value),
        values.map(value => value)
      )
    def id: Optional[QueryIdentifier]
    def timestamps: Optional[List[Timestamp]]
    def values: Optional[List[Counter]]
    def getId: ZIO[Any, AwsError, QueryIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
    def getValues: ZIO[Any, AwsError, List[Counter]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.MetricDataResult
  ) extends zio.aws.sesv2.model.MetricDataResult.ReadOnly {
    override val id: Optional[QueryIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.sesv2.model.primitives.QueryIdentifier(value))
    override val timestamps: Optional[List[Timestamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.Timestamp(item)
        }.toList
      )
    override val values: Optional[List[Counter]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.Counter(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.MetricDataResult
  ): zio.aws.sesv2.model.MetricDataResult.ReadOnly = new Wrapper(impl)
}
