package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{QueryErrorMessage, QueryIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricDataError(
    id: Optional[QueryIdentifier] = Optional.Absent,
    code: Optional[zio.aws.sesv2.model.QueryErrorCode] = Optional.Absent,
    message: Optional[QueryErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.MetricDataError = {
    import MetricDataError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.MetricDataError
      .builder()
      .optionallyWith(
        id.map(value => QueryIdentifier.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => QueryErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.MetricDataError.ReadOnly =
    zio.aws.sesv2.model.MetricDataError.wrap(buildAwsValue())
}
object MetricDataError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.MetricDataError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.MetricDataError =
      zio.aws.sesv2.model.MetricDataError(
        id.map(value => value),
        code.map(value => value),
        message.map(value => value)
      )
    def id: Optional[QueryIdentifier]
    def code: Optional[zio.aws.sesv2.model.QueryErrorCode]
    def message: Optional[QueryErrorMessage]
    def getId: ZIO[Any, AwsError, QueryIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getCode: ZIO[Any, AwsError, zio.aws.sesv2.model.QueryErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, QueryErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.MetricDataError
  ) extends zio.aws.sesv2.model.MetricDataError.ReadOnly {
    override val id: Optional[QueryIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.sesv2.model.primitives.QueryIdentifier(value))
    override val code: Optional[zio.aws.sesv2.model.QueryErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.sesv2.model.QueryErrorCode.wrap(value))
    override val message: Optional[QueryErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.sesv2.model.primitives.QueryErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.MetricDataError
  ): zio.aws.sesv2.model.MetricDataError.ReadOnly = new Wrapper(impl)
}
