package zio.aws.sesv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest = {
    import ListCustomVerificationEmailTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest =
      zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest(
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ) extends zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesRequest
  ): zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
