package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait ImportDestinationType {
  def unwrap: software.amazon.awssdk.services.sesv2.model.ImportDestinationType
}
object ImportDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.ImportDestinationType
  ): zio.aws.sesv2.model.ImportDestinationType = value match {
    case software.amazon.awssdk.services.sesv2.model.ImportDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.ImportDestinationType.SUPPRESSION_LIST =>
      val r = SUPPRESSION_LIST
      r
    case software.amazon.awssdk.services.sesv2.model.ImportDestinationType.CONTACT_LIST =>
      val r = CONTACT_LIST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.ImportDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ImportDestinationType =
      software.amazon.awssdk.services.sesv2.model.ImportDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUPPRESSION_LIST
      extends zio.aws.sesv2.model.ImportDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ImportDestinationType =
      software.amazon.awssdk.services.sesv2.model.ImportDestinationType.SUPPRESSION_LIST
  }
  case object CONTACT_LIST extends zio.aws.sesv2.model.ImportDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ImportDestinationType =
      software.amazon.awssdk.services.sesv2.model.ImportDestinationType.CONTACT_LIST
  }
}
