package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, Domain}
import scala.jdk.CollectionConverters.*
final case class DomainDeliverabilityTrackingOption(
    domain: Optional[Domain] = Optional.Absent,
    subscriptionStartDate: Optional[Timestamp] = Optional.Absent,
    inboxPlacementTrackingOption: Optional[
      zio.aws.sesv2.model.InboxPlacementTrackingOption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption = {
    import DomainDeliverabilityTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
      .builder()
      .optionallyWith(
        domain.map(value => Domain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        subscriptionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionStartDate)
      .optionallyWith(
        inboxPlacementTrackingOption.map(value => value.buildAwsValue())
      )(_.inboxPlacementTrackingOption)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly =
    zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.wrap(buildAwsValue())
}
object DomainDeliverabilityTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DomainDeliverabilityTrackingOption =
      zio.aws.sesv2.model.DomainDeliverabilityTrackingOption(
        domain.map(value => value),
        subscriptionStartDate.map(value => value),
        inboxPlacementTrackingOption.map(value => value.asEditable)
      )
    def domain: Optional[Domain]
    def subscriptionStartDate: Optional[Timestamp]
    def inboxPlacementTrackingOption
        : Optional[zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly]
    def getDomain: ZIO[Any, AwsError, Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getInboxPlacementTrackingOption: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboxPlacementTrackingOption",
      inboxPlacementTrackingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ) extends zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly {
    override val domain: Optional[Domain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.sesv2.model.primitives.Domain(value))
    override val subscriptionStartDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionStartDate())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val inboxPlacementTrackingOption
        : Optional[zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboxPlacementTrackingOption())
        .map(value =>
          zio.aws.sesv2.model.InboxPlacementTrackingOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityTrackingOption
  ): zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly =
    new Wrapper(impl)
}
