package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  Timestamp,
  MetricDimensionValue,
  QueryIdentifier
}
import scala.jdk.CollectionConverters.*
final case class BatchGetMetricDataQuery(
    id: QueryIdentifier,
    namespace: zio.aws.sesv2.model.MetricNamespace,
    metric: zio.aws.sesv2.model.Metric,
    dimensions: Optional[
      Map[zio.aws.sesv2.model.MetricDimensionName, MetricDimensionValue]
    ] = Optional.Absent,
    startDate: Timestamp,
    endDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery = {
    import BatchGetMetricDataQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery
      .builder()
      .id(QueryIdentifier.unwrap(id): java.lang.String)
      .namespace(namespace.unwrap)
      .metric(metric.unwrap)
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (MetricDimensionValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.dimensionsWithStrings)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly =
    zio.aws.sesv2.model.BatchGetMetricDataQuery.wrap(buildAwsValue())
}
object BatchGetMetricDataQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BatchGetMetricDataQuery =
      zio.aws.sesv2.model.BatchGetMetricDataQuery(
        id,
        namespace,
        metric,
        dimensions.map(value => value),
        startDate,
        endDate
      )
    def id: QueryIdentifier
    def namespace: zio.aws.sesv2.model.MetricNamespace
    def metric: zio.aws.sesv2.model.Metric
    def dimensions: Optional[
      Map[zio.aws.sesv2.model.MetricDimensionName, MetricDimensionValue]
    ]
    def startDate: Timestamp
    def endDate: Timestamp
    def getId: ZIO[Any, Nothing, QueryIdentifier] = ZIO.succeed(id)
    def getNamespace: ZIO[Any, Nothing, zio.aws.sesv2.model.MetricNamespace] =
      ZIO.succeed(namespace)
    def getMetric: ZIO[Any, Nothing, zio.aws.sesv2.model.Metric] =
      ZIO.succeed(metric)
    def getDimensions: ZIO[Any, AwsError, Map[
      zio.aws.sesv2.model.MetricDimensionName,
      MetricDimensionValue
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery
  ) extends zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly {
    override val id: QueryIdentifier =
      zio.aws.sesv2.model.primitives.QueryIdentifier(impl.id())
    override val namespace: zio.aws.sesv2.model.MetricNamespace =
      zio.aws.sesv2.model.MetricNamespace.wrap(impl.namespace())
    override val metric: zio.aws.sesv2.model.Metric =
      zio.aws.sesv2.model.Metric.wrap(impl.metric())
    override val dimensions: Optional[
      Map[zio.aws.sesv2.model.MetricDimensionName, MetricDimensionValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sesv2.model.MetricDimensionName.wrap(
              key
            ) -> zio.aws.sesv2.model.primitives.MetricDimensionValue(value)
          })
          .toMap
      )
    override val startDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.sesv2.model.primitives.Timestamp(impl.endDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataQuery
  ): zio.aws.sesv2.model.BatchGetMetricDataQuery.ReadOnly = new Wrapper(impl)
}
