package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{SendingPoolName, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetDeliveryOptionsRequest(
    configurationSetName: ConfigurationSetName,
    tlsPolicy: Optional[zio.aws.sesv2.model.TlsPolicy] = Optional.Absent,
    sendingPoolName: Optional[SendingPoolName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest = {
    import PutConfigurationSetDeliveryOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(tlsPolicy.map(value => value.unwrap))(_.tlsPolicy)
      .optionallyWith(
        sendingPoolName.map(value =>
          SendingPoolName.unwrap(value): java.lang.String
        )
      )(_.sendingPoolName)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetDeliveryOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest(
        configurationSetName,
        tlsPolicy.map(value => value),
        sendingPoolName.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def tlsPolicy: Optional[zio.aws.sesv2.model.TlsPolicy]
    def sendingPoolName: Optional[SendingPoolName]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTlsPolicy: ZIO[Any, AwsError, zio.aws.sesv2.model.TlsPolicy] =
      AwsError.unwrapOptionField("tlsPolicy", tlsPolicy)
    def getSendingPoolName: ZIO[Any, AwsError, SendingPoolName] =
      AwsError.unwrapOptionField("sendingPoolName", sendingPoolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val tlsPolicy: Optional[zio.aws.sesv2.model.TlsPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsPolicy())
        .map(value => zio.aws.sesv2.model.TlsPolicy.wrap(value))
    override val sendingPoolName: Optional[SendingPoolName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendingPoolName())
        .map(value => zio.aws.sesv2.model.primitives.SendingPoolName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
