package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListContactsFilter(
    filteredStatus: Optional[zio.aws.sesv2.model.SubscriptionStatus] =
      Optional.Absent,
    topicFilter: Optional[zio.aws.sesv2.model.TopicFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListContactsFilter = {
    import ListContactsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListContactsFilter
      .builder()
      .optionallyWith(filteredStatus.map(value => value.unwrap))(
        _.filteredStatus
      )
      .optionallyWith(topicFilter.map(value => value.buildAwsValue()))(
        _.topicFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListContactsFilter.ReadOnly =
    zio.aws.sesv2.model.ListContactsFilter.wrap(buildAwsValue())
}
object ListContactsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListContactsFilter =
      zio.aws.sesv2.model.ListContactsFilter(
        filteredStatus.map(value => value),
        topicFilter.map(value => value.asEditable)
      )
    def filteredStatus: Optional[zio.aws.sesv2.model.SubscriptionStatus]
    def topicFilter: Optional[zio.aws.sesv2.model.TopicFilter.ReadOnly]
    def getFilteredStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SubscriptionStatus] =
      AwsError.unwrapOptionField("filteredStatus", filteredStatus)
    def getTopicFilter
        : ZIO[Any, AwsError, zio.aws.sesv2.model.TopicFilter.ReadOnly] =
      AwsError.unwrapOptionField("topicFilter", topicFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ) extends zio.aws.sesv2.model.ListContactsFilter.ReadOnly {
    override val filteredStatus
        : Optional[zio.aws.sesv2.model.SubscriptionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filteredStatus())
        .map(value => zio.aws.sesv2.model.SubscriptionStatus.wrap(value))
    override val topicFilter
        : Optional[zio.aws.sesv2.model.TopicFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicFilter())
        .map(value => zio.aws.sesv2.model.TopicFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListContactsFilter
  ): zio.aws.sesv2.model.ListContactsFilter.ReadOnly = new Wrapper(impl)
}
