package zio.aws.sesv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken, PoolName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpsRequest(
    poolName: Optional[PoolName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest = {
    import GetDedicatedIpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest
      .builder()
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpsRequest.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpsRequest.wrap(buildAwsValue())
}
object GetDedicatedIpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpsRequest =
      zio.aws.sesv2.model.GetDedicatedIpsRequest(
        poolName.map(value => value),
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def poolName: Optional[PoolName]
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest
  ) extends zio.aws.sesv2.model.GetDedicatedIpsRequest.ReadOnly {
    override val poolName: Optional[PoolName] = zio.aws.core.internal
      .optionalFromNullable(impl.poolName())
      .map(value => zio.aws.sesv2.model.primitives.PoolName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest
  ): zio.aws.sesv2.model.GetDedicatedIpsRequest.ReadOnly = new Wrapper(impl)
}
