package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait DkimSigningKeyLength {
  def unwrap: software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength
}
object DkimSigningKeyLength {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength
  ): zio.aws.sesv2.model.DkimSigningKeyLength = value match {
    case software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.RSA_1024_BIT =>
      val r = RSA_1024_BIT
      r
    case software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.RSA_2048_BIT =>
      val r = RSA_2048_BIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.DkimSigningKeyLength {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength =
      software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_1024_BIT extends zio.aws.sesv2.model.DkimSigningKeyLength {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength =
      software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.RSA_1024_BIT
  }
  case object RSA_2048_BIT extends zio.aws.sesv2.model.DkimSigningKeyLength {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength =
      software.amazon.awssdk.services.sesv2.model.DkimSigningKeyLength.RSA_2048_BIT
  }
}
