package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  AdditionalContactEmailAddress,
  UseCaseDescription,
  WebsiteURL
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountDetails(
    mailType: Optional[zio.aws.sesv2.model.MailType] = Optional.Absent,
    websiteURL: Optional[WebsiteURL] = Optional.Absent,
    contactLanguage: Optional[zio.aws.sesv2.model.ContactLanguage] =
      Optional.Absent,
    useCaseDescription: Optional[UseCaseDescription] = Optional.Absent,
    additionalContactEmailAddresses: Optional[
      Iterable[AdditionalContactEmailAddress]
    ] = Optional.Absent,
    reviewDetails: Optional[zio.aws.sesv2.model.ReviewDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.AccountDetails = {
    import AccountDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.AccountDetails
      .builder()
      .optionallyWith(mailType.map(value => value.unwrap))(_.mailType)
      .optionallyWith(
        websiteURL.map(value => WebsiteURL.unwrap(value): java.lang.String)
      )(_.websiteURL)
      .optionallyWith(contactLanguage.map(value => value.unwrap))(
        _.contactLanguage
      )
      .optionallyWith(
        useCaseDescription.map(value =>
          UseCaseDescription.unwrap(value): java.lang.String
        )
      )(_.useCaseDescription)
      .optionallyWith(
        additionalContactEmailAddresses.map(value =>
          value.map { item =>
            AdditionalContactEmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalContactEmailAddresses)
      .optionallyWith(reviewDetails.map(value => value.buildAwsValue()))(
        _.reviewDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.AccountDetails.ReadOnly =
    zio.aws.sesv2.model.AccountDetails.wrap(buildAwsValue())
}
object AccountDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.AccountDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.AccountDetails =
      zio.aws.sesv2.model.AccountDetails(
        mailType.map(value => value),
        websiteURL.map(value => value),
        contactLanguage.map(value => value),
        useCaseDescription.map(value => value),
        additionalContactEmailAddresses.map(value => value),
        reviewDetails.map(value => value.asEditable)
      )
    def mailType: Optional[zio.aws.sesv2.model.MailType]
    def websiteURL: Optional[WebsiteURL]
    def contactLanguage: Optional[zio.aws.sesv2.model.ContactLanguage]
    def useCaseDescription: Optional[UseCaseDescription]
    def additionalContactEmailAddresses
        : Optional[List[AdditionalContactEmailAddress]]
    def reviewDetails: Optional[zio.aws.sesv2.model.ReviewDetails.ReadOnly]
    def getMailType: ZIO[Any, AwsError, zio.aws.sesv2.model.MailType] =
      AwsError.unwrapOptionField("mailType", mailType)
    def getWebsiteURL: ZIO[Any, AwsError, WebsiteURL] =
      AwsError.unwrapOptionField("websiteURL", websiteURL)
    def getContactLanguage
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ContactLanguage] =
      AwsError.unwrapOptionField("contactLanguage", contactLanguage)
    def getUseCaseDescription: ZIO[Any, AwsError, UseCaseDescription] =
      AwsError.unwrapOptionField("useCaseDescription", useCaseDescription)
    def getAdditionalContactEmailAddresses
        : ZIO[Any, AwsError, List[AdditionalContactEmailAddress]] =
      AwsError.unwrapOptionField(
        "additionalContactEmailAddresses",
        additionalContactEmailAddresses
      )
    def getReviewDetails
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ReviewDetails.ReadOnly] =
      AwsError.unwrapOptionField("reviewDetails", reviewDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.AccountDetails
  ) extends zio.aws.sesv2.model.AccountDetails.ReadOnly {
    override val mailType: Optional[zio.aws.sesv2.model.MailType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mailType())
        .map(value => zio.aws.sesv2.model.MailType.wrap(value))
    override val websiteURL: Optional[WebsiteURL] = zio.aws.core.internal
      .optionalFromNullable(impl.websiteURL())
      .map(value => zio.aws.sesv2.model.primitives.WebsiteURL(value))
    override val contactLanguage
        : Optional[zio.aws.sesv2.model.ContactLanguage] = zio.aws.core.internal
      .optionalFromNullable(impl.contactLanguage())
      .map(value => zio.aws.sesv2.model.ContactLanguage.wrap(value))
    override val useCaseDescription: Optional[UseCaseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useCaseDescription())
        .map(value => zio.aws.sesv2.model.primitives.UseCaseDescription(value))
    override val additionalContactEmailAddresses
        : Optional[List[AdditionalContactEmailAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalContactEmailAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.AdditionalContactEmailAddress(item)
        }.toList
      )
    override val reviewDetails
        : Optional[zio.aws.sesv2.model.ReviewDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviewDetails())
        .map(value => zio.aws.sesv2.model.ReviewDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.AccountDetails
  ): zio.aws.sesv2.model.AccountDetails.ReadOnly = new Wrapper(impl)
}
