package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.CustomRedirectDomain
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TrackingOptions(customRedirectDomain: CustomRedirectDomain) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TrackingOptions = {
    import TrackingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TrackingOptions
      .builder()
      .customRedirectDomain(
        CustomRedirectDomain.unwrap(customRedirectDomain): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TrackingOptions.ReadOnly =
    zio.aws.sesv2.model.TrackingOptions.wrap(buildAwsValue())
}
object TrackingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.TrackingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TrackingOptions =
      zio.aws.sesv2.model.TrackingOptions(customRedirectDomain)
    def customRedirectDomain: CustomRedirectDomain
    def getCustomRedirectDomain: ZIO[Any, Nothing, CustomRedirectDomain] =
      ZIO.succeed(customRedirectDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TrackingOptions
  ) extends zio.aws.sesv2.model.TrackingOptions.ReadOnly {
    override val customRedirectDomain: CustomRedirectDomain =
      zio.aws.sesv2.model.primitives
        .CustomRedirectDomain(impl.customRedirectDomain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TrackingOptions
  ): zio.aws.sesv2.model.TrackingOptions.ReadOnly = new Wrapper(impl)
}
