package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDomainDeliverabilityCampaignsResponse(
    domainDeliverabilityCampaigns: Iterable[
      zio.aws.sesv2.model.DomainDeliverabilityCampaign
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse = {
    import ListDomainDeliverabilityCampaignsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse
      .builder()
      .domainDeliverabilityCampaigns(domainDeliverabilityCampaigns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly =
    zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse
      .wrap(buildAwsValue())
}
object ListDomainDeliverabilityCampaignsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse =
      zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse(
        domainDeliverabilityCampaigns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def domainDeliverabilityCampaigns
        : List[zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly]
    def nextToken: Optional[NextToken]
    def getDomainDeliverabilityCampaigns: ZIO[Any, Nothing, List[
      zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
    ]] = ZIO.succeed(domainDeliverabilityCampaigns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse
  ) extends zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly {
    override val domainDeliverabilityCampaigns
        : List[zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly] = impl
      .domainDeliverabilityCampaigns()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.DomainDeliverabilityCampaign.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse
  ): zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly =
    new Wrapper(impl)
}
