package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesResponse(
    customVerificationEmailTemplates: Optional[
      Iterable[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse = {
    import ListCustomVerificationEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
      .builder()
      .optionallyWith(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customVerificationEmailTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse =
      zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customVerificationEmailTemplates: Optional[
      List[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCustomVerificationEmailTemplates: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customVerificationEmailTemplates",
      customVerificationEmailTemplates
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ) extends zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly {
    override val customVerificationEmailTemplates: Optional[
      List[zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customVerificationEmailTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListCustomVerificationEmailTemplatesResponse
  ): zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
