package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, EmailTemplateName}
import scala.jdk.CollectionConverters.*
final case class EmailTemplateMetadata(
    templateName: Optional[EmailTemplateName] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata = {
    import EmailTemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly =
    zio.aws.sesv2.model.EmailTemplateMetadata.wrap(buildAwsValue())
}
object EmailTemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.EmailTemplateMetadata =
      zio.aws.sesv2.model.EmailTemplateMetadata(
        templateName.map(value => value),
        createdTimestamp.map(value => value)
      )
    def templateName: Optional[EmailTemplateName]
    def createdTimestamp: Optional[Timestamp]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ) extends zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly {
    override val templateName: Optional[EmailTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata
  ): zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly = new Wrapper(impl)
}
