package zio.aws.sesv2
import zio.aws.sesv2.model.DeleteDedicatedIpPoolResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.sesv2.model.primitives.{ConfigurationSetName, PoolName}
import zio.aws.sesv2.model.{
  DeleteSuppressedDestinationRequest,
  PutEmailIdentityConfigurationSetAttributesRequest,
  DeleteDedicatedIpPoolRequest,
  UpdateEmailIdentityPolicyRequest,
  TestRenderEmailTemplateRequest,
  GetEmailIdentityPoliciesRequest,
  CreateContactRequest,
  UpdateContactListRequest,
  PutConfigurationSetSuppressionOptionsRequest,
  DeleteConfigurationSetRequest,
  PutDeliverabilityDashboardOptionRequest,
  DeleteContactListRequest,
  GetDedicatedIpRequest,
  UpdateConfigurationSetEventDestinationRequest,
  DeleteCustomVerificationEmailTemplateRequest,
  CreateDeliverabilityTestReportRequest,
  DeleteContactRequest,
  GetDomainDeliverabilityCampaignRequest,
  CreateContactListRequest,
  PutConfigurationSetSendingOptionsRequest,
  ListContactListsRequest,
  GetEmailIdentityRequest,
  PutAccountSendingAttributesRequest,
  PutAccountDetailsRequest,
  PutEmailIdentityFeedbackAttributesRequest,
  ListEmailTemplatesRequest,
  GetContactRequest,
  PutDedicatedIpWarmupAttributesRequest,
  ListTagsForResourceRequest,
  CreateConfigurationSetRequest,
  CreateEmailIdentityRequest,
  PutAccountDedicatedIpWarmupAttributesRequest,
  UpdateEmailTemplateRequest,
  GetEmailTemplateRequest,
  GetConfigurationSetRequest,
  GetBlacklistReportsRequest,
  ListImportJobsRequest,
  GetDedicatedIpsRequest,
  ListDedicatedIpPoolsRequest,
  CreateEmailIdentityPolicyRequest,
  ListEmailIdentitiesRequest,
  PutEmailIdentityDkimAttributesRequest,
  ListSuppressedDestinationsRequest,
  SendEmailRequest,
  PutConfigurationSetTrackingOptionsRequest,
  GetAccountRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  PutSuppressedDestinationRequest,
  ListConfigurationSetsRequest,
  UpdateCustomVerificationEmailTemplateRequest,
  PutEmailIdentityDkimSigningAttributesRequest,
  GetConfigurationSetEventDestinationsRequest,
  ListDeliverabilityTestReportsRequest,
  GetDomainStatisticsReportRequest,
  CreateConfigurationSetEventDestinationRequest,
  PutAccountSuppressionAttributesRequest,
  GetImportJobRequest,
  DeleteEmailTemplateRequest,
  ListCustomVerificationEmailTemplatesRequest,
  UntagResourceRequest,
  GetSuppressedDestinationRequest,
  ListContactsRequest,
  PutDedicatedIpInPoolRequest,
  GetDeliverabilityDashboardOptionsRequest,
  PutConfigurationSetReputationOptionsRequest,
  DeleteConfigurationSetEventDestinationRequest,
  DeleteEmailIdentityPolicyRequest,
  CreateEmailTemplateRequest,
  ListDomainDeliverabilityCampaignsRequest,
  CreateDedicatedIpPoolRequest,
  SendCustomVerificationEmailRequest,
  GetContactListRequest,
  GetDeliverabilityTestReportRequest,
  PutEmailIdentityMailFromAttributesRequest,
  CreateImportJobRequest,
  CreateCustomVerificationEmailTemplateRequest,
  UpdateContactRequest,
  TagResourceRequest,
  SendBulkEmailRequest,
  GetCustomVerificationEmailTemplateRequest,
  DeleteEmailIdentityRequest
}
object SesV2Mock extends Mock[SesV2] {
  object UpdateContact
      extends Effect[
        UpdateContactRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateContactResponse.ReadOnly
      ]
  object SendBulkEmail
      extends Effect[
        SendBulkEmailRequest,
        AwsError,
        zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly
      ]
  object PutAccountDetails
      extends Effect[
        PutAccountDetailsRequest,
        AwsError,
        zio.aws.sesv2.model.PutAccountDetailsResponse.ReadOnly
      ]
  object GetConfigurationSet
      extends Effect[
        GetConfigurationSetRequest,
        AwsError,
        zio.aws.sesv2.model.GetConfigurationSetResponse.ReadOnly
      ]
  object DeleteEmailIdentityPolicy
      extends Effect[
        DeleteEmailIdentityPolicyRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.ReadOnly
      ]
  object CreateContactList
      extends Effect[
        CreateContactListRequest,
        AwsError,
        zio.aws.sesv2.model.CreateContactListResponse.ReadOnly
      ]
  object PutEmailIdentityConfigurationSetAttributes
      extends Effect[
        PutEmailIdentityConfigurationSetAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.ReadOnly
      ]
  object GetDomainDeliverabilityCampaign
      extends Effect[
        GetDomainDeliverabilityCampaignRequest,
        AwsError,
        zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
      ]
  object CreateConfigurationSetEventDestination
      extends Effect[
        CreateConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object PutConfigurationSetReputationOptions
      extends Effect[
        PutConfigurationSetReputationOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
      ]
  object GetContactList
      extends Effect[
        GetContactListRequest,
        AwsError,
        zio.aws.sesv2.model.GetContactListResponse.ReadOnly
      ]
  object DeleteSuppressedDestination
      extends Effect[
        DeleteSuppressedDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.ReadOnly
      ]
  object PutAccountSendingAttributes
      extends Effect[
        PutAccountSendingAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutAccountSendingAttributesResponse.ReadOnly
      ]
  object ListEmailIdentities
      extends Stream[
        ListEmailIdentitiesRequest,
        AwsError,
        zio.aws.sesv2.model.IdentityInfo.ReadOnly
      ]
  object ListEmailIdentitiesPaginated
      extends Effect[
        ListEmailIdentitiesRequest,
        AwsError,
        zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly
      ]
  object GetEmailTemplate
      extends Effect[
        GetEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly
      ]
  object CreateEmailIdentity
      extends Effect[
        CreateEmailIdentityRequest,
        AwsError,
        zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly
      ]
  object ListDedicatedIpPools
      extends Stream[ListDedicatedIpPoolsRequest, AwsError, PoolName]
  object ListDedicatedIpPoolsPaginated
      extends Effect[
        ListDedicatedIpPoolsRequest,
        AwsError,
        zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly
      ]
  object CreateEmailTemplate
      extends Effect[
        CreateEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.CreateEmailTemplateResponse.ReadOnly
      ]
  object PutAccountDedicatedIpWarmupAttributes
      extends Effect[
        PutAccountDedicatedIpWarmupAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
      ]
  object GetConfigurationSetEventDestinations
      extends Effect[
        GetConfigurationSetEventDestinationsRequest,
        AwsError,
        zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
      ]
  object SendEmail
      extends Effect[
        SendEmailRequest,
        AwsError,
        zio.aws.sesv2.model.SendEmailResponse.ReadOnly
      ]
  object GetEmailIdentity
      extends Effect[
        GetEmailIdentityRequest,
        AwsError,
        zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly
      ]
  object PutEmailIdentityDkimSigningAttributes
      extends Effect[
        PutEmailIdentityDkimSigningAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly
      ]
  object PutConfigurationSetTrackingOptions
      extends Effect[
        PutConfigurationSetTrackingOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
      ]
  object ListImportJobs
      extends Stream[
        ListImportJobsRequest,
        AwsError,
        zio.aws.sesv2.model.ImportJobSummary.ReadOnly
      ]
  object ListImportJobsPaginated
      extends Effect[
        ListImportJobsRequest,
        AwsError,
        zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly
      ]
  object CreateCustomVerificationEmailTemplate
      extends Effect[
        CreateCustomVerificationEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.ReadOnly
      ]
  object DeleteEmailIdentity
      extends Effect[
        DeleteEmailIdentityRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteEmailIdentityResponse.ReadOnly
      ]
  object DeleteContact
      extends Effect[
        DeleteContactRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteContactResponse.ReadOnly
      ]
  object GetDeliverabilityDashboardOptions
      extends Effect[
        GetDeliverabilityDashboardOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
      ]
  object CreateContact
      extends Effect[
        CreateContactRequest,
        AwsError,
        zio.aws.sesv2.model.CreateContactResponse.ReadOnly
      ]
  object GetAccount
      extends Effect[
        GetAccountRequest,
        AwsError,
        zio.aws.sesv2.model.GetAccountResponse.ReadOnly
      ]
  object GetDomainStatisticsReport
      extends Effect[
        GetDomainStatisticsReportRequest,
        AwsError,
        zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly
      ]
  object ListEmailTemplates
      extends Stream[
        ListEmailTemplatesRequest,
        AwsError,
        zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
      ]
  object ListEmailTemplatesPaginated
      extends Effect[
        ListEmailTemplatesRequest,
        AwsError,
        zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly
      ]
  object ListSuppressedDestinations
      extends Stream[
        ListSuppressedDestinationsRequest,
        AwsError,
        zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
      ]
  object ListSuppressedDestinationsPaginated
      extends Effect[
        ListSuppressedDestinationsRequest,
        AwsError,
        zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly
      ]
  object UpdateEmailIdentityPolicy
      extends Effect[
        UpdateEmailIdentityPolicyRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.ReadOnly
      ]
  object PutSuppressedDestination
      extends Effect[
        PutSuppressedDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.PutSuppressedDestinationResponse.ReadOnly
      ]
  object PutConfigurationSetSuppressionOptions
      extends Effect[
        PutConfigurationSetSuppressionOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.ReadOnly
      ]
  object GetDedicatedIps
      extends Stream[
        GetDedicatedIpsRequest,
        AwsError,
        zio.aws.sesv2.model.DedicatedIp.ReadOnly
      ]
  object GetDedicatedIpsPaginated
      extends Effect[
        GetDedicatedIpsRequest,
        AwsError,
        zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly
      ]
  object CreateDeliverabilityTestReport
      extends Effect[
        CreateDeliverabilityTestReportRequest,
        AwsError,
        zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly
      ]
  object ListDomainDeliverabilityCampaigns
      extends Stream[
        ListDomainDeliverabilityCampaignsRequest,
        AwsError,
        zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
      ]
  object ListDomainDeliverabilityCampaignsPaginated
      extends Effect[
        ListDomainDeliverabilityCampaignsRequest,
        AwsError,
        zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
      ]
  object CreateImportJob
      extends Effect[
        CreateImportJobRequest,
        AwsError,
        zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly
      ]
  object GetBlacklistReports
      extends Effect[
        GetBlacklistReportsRequest,
        AwsError,
        zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly
      ]
  object TestRenderEmailTemplate
      extends Effect[
        TestRenderEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly
      ]
  object ListCustomVerificationEmailTemplates
      extends Stream[
        ListCustomVerificationEmailTemplatesRequest,
        AwsError,
        zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
      ]
  object ListCustomVerificationEmailTemplatesPaginated
      extends Effect[
        ListCustomVerificationEmailTemplatesRequest,
        AwsError,
        zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
      ]
  object CreateEmailIdentityPolicy
      extends Effect[
        CreateEmailIdentityPolicyRequest,
        AwsError,
        zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.sesv2.model.UntagResourceResponse.ReadOnly
      ]
  object CreateDedicatedIpPool
      extends Effect[
        CreateDedicatedIpPoolRequest,
        AwsError,
        zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.ReadOnly
      ]
  object ListContactLists
      extends Stream[
        ListContactListsRequest,
        AwsError,
        zio.aws.sesv2.model.ContactList.ReadOnly
      ]
  object ListContactListsPaginated
      extends Effect[
        ListContactListsRequest,
        AwsError,
        zio.aws.sesv2.model.ListContactListsResponse.ReadOnly
      ]
  object UpdateCustomVerificationEmailTemplate
      extends Effect[
        UpdateCustomVerificationEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.ReadOnly
      ]
  object DeleteEmailTemplate
      extends Effect[
        DeleteEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteEmailTemplateResponse.ReadOnly
      ]
  object ListConfigurationSets
      extends Stream[
        ListConfigurationSetsRequest,
        AwsError,
        ConfigurationSetName
      ]
  object ListConfigurationSetsPaginated
      extends Effect[
        ListConfigurationSetsRequest,
        AwsError,
        zio.aws.sesv2.model.ListConfigurationSetsResponse.ReadOnly
      ]
  object PutEmailIdentityMailFromAttributes
      extends Effect[
        PutEmailIdentityMailFromAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
      ]
  object PutEmailIdentityFeedbackAttributes
      extends Effect[
        PutEmailIdentityFeedbackAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
      ]
  object UpdateContactList
      extends Effect[
        UpdateContactListRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateContactListResponse.ReadOnly
      ]
  object DeleteCustomVerificationEmailTemplate
      extends Effect[
        DeleteCustomVerificationEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteDedicatedIpPool
      extends Effect[DeleteDedicatedIpPoolRequest, AwsError, ReadOnly]
  object GetDedicatedIp
      extends Effect[
        GetDedicatedIpRequest,
        AwsError,
        zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly
      ]
  object UpdateEmailTemplate
      extends Effect[
        UpdateEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateEmailTemplateResponse.ReadOnly
      ]
  object PutDeliverabilityDashboardOption
      extends Effect[
        PutDeliverabilityDashboardOptionRequest,
        AwsError,
        zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.sesv2.model.TagResourceResponse.ReadOnly
      ]
  object GetEmailIdentityPolicies
      extends Effect[
        GetEmailIdentityPoliciesRequest,
        AwsError,
        zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly
      ]
  object DeleteConfigurationSet
      extends Effect[
        DeleteConfigurationSetRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteConfigurationSetResponse.ReadOnly
      ]
  object CreateConfigurationSet
      extends Effect[
        CreateConfigurationSetRequest,
        AwsError,
        zio.aws.sesv2.model.CreateConfigurationSetResponse.ReadOnly
      ]
  object ListDeliverabilityTestReports
      extends Stream[
        ListDeliverabilityTestReportsRequest,
        AwsError,
        zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
      ]
  object ListDeliverabilityTestReportsPaginated
      extends Effect[
        ListDeliverabilityTestReportsRequest,
        AwsError,
        zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly
      ]
  object GetImportJob
      extends Effect[
        GetImportJobRequest,
        AwsError,
        zio.aws.sesv2.model.GetImportJobResponse.ReadOnly
      ]
  object GetContact
      extends Effect[
        GetContactRequest,
        AwsError,
        zio.aws.sesv2.model.GetContactResponse.ReadOnly
      ]
  object ListContacts
      extends Stream[
        ListContactsRequest,
        AwsError,
        zio.aws.sesv2.model.Contact.ReadOnly
      ]
  object ListContactsPaginated
      extends Effect[
        ListContactsRequest,
        AwsError,
        zio.aws.sesv2.model.ListContactsResponse.ReadOnly
      ]
  object UpdateConfigurationSetEventDestination
      extends Effect[
        UpdateConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object PutDedicatedIpInPool
      extends Effect[
        PutDedicatedIpInPoolRequest,
        AwsError,
        zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.ReadOnly
      ]
  object GetCustomVerificationEmailTemplate
      extends Effect[
        GetCustomVerificationEmailTemplateRequest,
        AwsError,
        zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
      ]
  object SendCustomVerificationEmail
      extends Effect[
        SendCustomVerificationEmailRequest,
        AwsError,
        zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly
      ]
  object PutConfigurationSetSendingOptions
      extends Effect[
        PutConfigurationSetSendingOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
      ]
  object GetSuppressedDestination
      extends Effect[
        GetSuppressedDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.GetSuppressedDestinationResponse.ReadOnly
      ]
  object PutConfigurationSetDeliveryOptions
      extends Effect[
        PutConfigurationSetDeliveryOptionsRequest,
        AwsError,
        zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
      ]
  object GetDeliverabilityTestReport
      extends Effect[
        GetDeliverabilityTestReportRequest,
        AwsError,
        zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly
      ]
  object PutAccountSuppressionAttributes
      extends Effect[
        PutAccountSuppressionAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.ReadOnly
      ]
  object PutDedicatedIpWarmupAttributes
      extends Effect[
        PutDedicatedIpWarmupAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
      ]
  object DeleteConfigurationSetEventDestination
      extends Effect[
        DeleteConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object PutEmailIdentityDkimAttributes
      extends Effect[
        PutEmailIdentityDkimAttributesRequest,
        AwsError,
        zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
      ]
  object DeleteContactList
      extends Effect[
        DeleteContactListRequest,
        AwsError,
        zio.aws.sesv2.model.DeleteContactListResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SesV2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SesV2] { rts =>
        zio.ZIO.succeed {
          new SesV2 {
            val api: SesV2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SesV2 = this
            def updateContact(request: UpdateContactRequest): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateContactResponse.ReadOnly
            ] = proxy(UpdateContact, request)
            def sendBulkEmail(request: SendBulkEmailRequest): IO[
              AwsError,
              zio.aws.sesv2.model.SendBulkEmailResponse.ReadOnly
            ] = proxy(SendBulkEmail, request)
            def putAccountDetails(request: PutAccountDetailsRequest): IO[
              AwsError,
              zio.aws.sesv2.model.PutAccountDetailsResponse.ReadOnly
            ] = proxy(PutAccountDetails, request)
            def getConfigurationSet(request: GetConfigurationSetRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetConfigurationSetResponse.ReadOnly
            ] = proxy(GetConfigurationSet, request)
            def deleteEmailIdentityPolicy(
                request: DeleteEmailIdentityPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteEmailIdentityPolicyResponse.ReadOnly
            ] = proxy(DeleteEmailIdentityPolicy, request)
            def createContactList(request: CreateContactListRequest): IO[
              AwsError,
              zio.aws.sesv2.model.CreateContactListResponse.ReadOnly
            ] = proxy(CreateContactList, request)
            def putEmailIdentityConfigurationSetAttributes(
                request: PutEmailIdentityConfigurationSetAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutEmailIdentityConfigurationSetAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityConfigurationSetAttributes, request)
            def getDomainDeliverabilityCampaign(
                request: GetDomainDeliverabilityCampaignRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
            ] = proxy(GetDomainDeliverabilityCampaign, request)
            def createConfigurationSetEventDestination(
                request: CreateConfigurationSetEventDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
            ] = proxy(CreateConfigurationSetEventDestination, request)
            def putConfigurationSetReputationOptions(
                request: PutConfigurationSetReputationOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetReputationOptions, request)
            def getContactList(request: GetContactListRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetContactListResponse.ReadOnly
            ] = proxy(GetContactList, request)
            def deleteSuppressedDestination(
                request: DeleteSuppressedDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteSuppressedDestinationResponse.ReadOnly
            ] = proxy(DeleteSuppressedDestination, request)
            def putAccountSendingAttributes(
                request: PutAccountSendingAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutAccountSendingAttributesResponse.ReadOnly
            ] = proxy(PutAccountSendingAttributes, request)
            def listEmailIdentities(
                request: ListEmailIdentitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.IdentityInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEmailIdentities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEmailIdentitiesPaginated(
                request: ListEmailIdentitiesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly
            ] = proxy(ListEmailIdentitiesPaginated, request)
            def getEmailTemplate(request: GetEmailTemplateRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetEmailTemplateResponse.ReadOnly
            ] = proxy(GetEmailTemplate, request)
            def createEmailIdentity(request: CreateEmailIdentityRequest): IO[
              AwsError,
              zio.aws.sesv2.model.CreateEmailIdentityResponse.ReadOnly
            ] = proxy(CreateEmailIdentity, request)
            def listDedicatedIpPools(
                request: ListDedicatedIpPoolsRequest
            ): ZStream[Any, AwsError, PoolName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDedicatedIpPools, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDedicatedIpPoolsPaginated(
                request: ListDedicatedIpPoolsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly
            ] = proxy(ListDedicatedIpPoolsPaginated, request)
            def createEmailTemplate(request: CreateEmailTemplateRequest): IO[
              AwsError,
              zio.aws.sesv2.model.CreateEmailTemplateResponse.ReadOnly
            ] = proxy(CreateEmailTemplate, request)
            def putAccountDedicatedIpWarmupAttributes(
                request: PutAccountDedicatedIpWarmupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
            ] = proxy(PutAccountDedicatedIpWarmupAttributes, request)
            def getConfigurationSetEventDestinations(
                request: GetConfigurationSetEventDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
            ] = proxy(GetConfigurationSetEventDestinations, request)
            def sendEmail(
                request: SendEmailRequest
            ): IO[AwsError, zio.aws.sesv2.model.SendEmailResponse.ReadOnly] =
              proxy(SendEmail, request)
            def getEmailIdentity(request: GetEmailIdentityRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly
            ] = proxy(GetEmailIdentity, request)
            def putEmailIdentityDkimSigningAttributes(
                request: PutEmailIdentityDkimSigningAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityDkimSigningAttributes, request)
            def putConfigurationSetTrackingOptions(
                request: PutConfigurationSetTrackingOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetTrackingOptions, request)
            def listImportJobs(request: ListImportJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.ImportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImportJobsPaginated(request: ListImportJobsRequest): IO[
              AwsError,
              zio.aws.sesv2.model.ListImportJobsResponse.ReadOnly
            ] = proxy(ListImportJobsPaginated, request)
            def createCustomVerificationEmailTemplate(
                request: CreateCustomVerificationEmailTemplateRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateCustomVerificationEmailTemplateResponse.ReadOnly
            ] = proxy(CreateCustomVerificationEmailTemplate, request)
            def deleteEmailIdentity(request: DeleteEmailIdentityRequest): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteEmailIdentityResponse.ReadOnly
            ] = proxy(DeleteEmailIdentity, request)
            def deleteContact(request: DeleteContactRequest): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteContactResponse.ReadOnly
            ] = proxy(DeleteContact, request)
            def getDeliverabilityDashboardOptions(
                request: GetDeliverabilityDashboardOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
            ] = proxy(GetDeliverabilityDashboardOptions, request)
            def createContact(request: CreateContactRequest): IO[
              AwsError,
              zio.aws.sesv2.model.CreateContactResponse.ReadOnly
            ] = proxy(CreateContact, request)
            def getAccount(
                request: GetAccountRequest
            ): IO[AwsError, zio.aws.sesv2.model.GetAccountResponse.ReadOnly] =
              proxy(GetAccount, request)
            def getDomainStatisticsReport(
                request: GetDomainStatisticsReportRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly
            ] = proxy(GetDomainStatisticsReport, request)
            def listEmailTemplates(request: ListEmailTemplatesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEmailTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEmailTemplatesPaginated(
                request: ListEmailTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly
            ] = proxy(ListEmailTemplatesPaginated, request)
            def listSuppressedDestinations(
                request: ListSuppressedDestinationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.SuppressedDestinationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSuppressedDestinations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSuppressedDestinationsPaginated(
                request: ListSuppressedDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListSuppressedDestinationsResponse.ReadOnly
            ] = proxy(ListSuppressedDestinationsPaginated, request)
            def updateEmailIdentityPolicy(
                request: UpdateEmailIdentityPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateEmailIdentityPolicyResponse.ReadOnly
            ] = proxy(UpdateEmailIdentityPolicy, request)
            def putSuppressedDestination(
                request: PutSuppressedDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutSuppressedDestinationResponse.ReadOnly
            ] = proxy(PutSuppressedDestination, request)
            def putConfigurationSetSuppressionOptions(
                request: PutConfigurationSetSuppressionOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutConfigurationSetSuppressionOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetSuppressionOptions, request)
            def getDedicatedIps(request: GetDedicatedIpsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.DedicatedIp.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetDedicatedIps, request)
                }
                .getOrThrowFiberFailure()
            }
            def getDedicatedIpsPaginated(request: GetDedicatedIpsRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly
            ] = proxy(GetDedicatedIpsPaginated, request)
            def createDeliverabilityTestReport(
                request: CreateDeliverabilityTestReportRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateDeliverabilityTestReportResponse.ReadOnly
            ] = proxy(CreateDeliverabilityTestReport, request)
            def listDomainDeliverabilityCampaigns(
                request: ListDomainDeliverabilityCampaignsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDomainDeliverabilityCampaigns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDomainDeliverabilityCampaignsPaginated(
                request: ListDomainDeliverabilityCampaignsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
            ] = proxy(ListDomainDeliverabilityCampaignsPaginated, request)
            def createImportJob(request: CreateImportJobRequest): IO[
              AwsError,
              zio.aws.sesv2.model.CreateImportJobResponse.ReadOnly
            ] = proxy(CreateImportJob, request)
            def getBlacklistReports(request: GetBlacklistReportsRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetBlacklistReportsResponse.ReadOnly
            ] = proxy(GetBlacklistReports, request)
            def testRenderEmailTemplate(
                request: TestRenderEmailTemplateRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly
            ] = proxy(TestRenderEmailTemplate, request)
            def listCustomVerificationEmailTemplates(
                request: ListCustomVerificationEmailTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomVerificationEmailTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomVerificationEmailTemplatesPaginated(
                request: ListCustomVerificationEmailTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly
            ] = proxy(ListCustomVerificationEmailTemplatesPaginated, request)
            def createEmailIdentityPolicy(
                request: CreateEmailIdentityPolicyRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateEmailIdentityPolicyResponse.ReadOnly
            ] = proxy(CreateEmailIdentityPolicy, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.sesv2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createDedicatedIpPool(
                request: CreateDedicatedIpPoolRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateDedicatedIpPoolResponse.ReadOnly
            ] = proxy(CreateDedicatedIpPool, request)
            def listContactLists(request: ListContactListsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.ContactList.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContactLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactListsPaginated(request: ListContactListsRequest): IO[
              AwsError,
              zio.aws.sesv2.model.ListContactListsResponse.ReadOnly
            ] = proxy(ListContactListsPaginated, request)
            def updateCustomVerificationEmailTemplate(
                request: UpdateCustomVerificationEmailTemplateRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateResponse.ReadOnly
            ] = proxy(UpdateCustomVerificationEmailTemplate, request)
            def deleteEmailTemplate(request: DeleteEmailTemplateRequest): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteEmailTemplateResponse.ReadOnly
            ] = proxy(DeleteEmailTemplate, request)
            def listConfigurationSets(
                request: ListConfigurationSetsRequest
            ): ZStream[Any, AwsError, ConfigurationSetName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListConfigurationSets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listConfigurationSetsPaginated(
                request: ListConfigurationSetsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListConfigurationSetsResponse.ReadOnly
            ] = proxy(ListConfigurationSetsPaginated, request)
            def putEmailIdentityMailFromAttributes(
                request: PutEmailIdentityMailFromAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityMailFromAttributes, request)
            def putEmailIdentityFeedbackAttributes(
                request: PutEmailIdentityFeedbackAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityFeedbackAttributes, request)
            def updateContactList(request: UpdateContactListRequest): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateContactListResponse.ReadOnly
            ] = proxy(UpdateContactList, request)
            def deleteCustomVerificationEmailTemplate(
                request: DeleteCustomVerificationEmailTemplateRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateResponse.ReadOnly
            ] = proxy(DeleteCustomVerificationEmailTemplate, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteDedicatedIpPool(
                request: DeleteDedicatedIpPoolRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteDedicatedIpPool, request)
            def getDedicatedIp(request: GetDedicatedIpRequest): IO[
              AwsError,
              zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly
            ] = proxy(GetDedicatedIp, request)
            def updateEmailTemplate(request: UpdateEmailTemplateRequest): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateEmailTemplateResponse.ReadOnly
            ] = proxy(UpdateEmailTemplate, request)
            def putDeliverabilityDashboardOption(
                request: PutDeliverabilityDashboardOptionRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
            ] = proxy(PutDeliverabilityDashboardOption, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.sesv2.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def getEmailIdentityPolicies(
                request: GetEmailIdentityPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly
            ] = proxy(GetEmailIdentityPolicies, request)
            def deleteConfigurationSet(
                request: DeleteConfigurationSetRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteConfigurationSetResponse.ReadOnly
            ] = proxy(DeleteConfigurationSet, request)
            def createConfigurationSet(
                request: CreateConfigurationSetRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.CreateConfigurationSetResponse.ReadOnly
            ] = proxy(CreateConfigurationSet, request)
            def listDeliverabilityTestReports(
                request: ListDeliverabilityTestReportsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDeliverabilityTestReports, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDeliverabilityTestReportsPaginated(
                request: ListDeliverabilityTestReportsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.ListDeliverabilityTestReportsResponse.ReadOnly
            ] = proxy(ListDeliverabilityTestReportsPaginated, request)
            def getImportJob(
                request: GetImportJobRequest
            ): IO[AwsError, zio.aws.sesv2.model.GetImportJobResponse.ReadOnly] =
              proxy(GetImportJob, request)
            def getContact(
                request: GetContactRequest
            ): IO[AwsError, zio.aws.sesv2.model.GetContactResponse.ReadOnly] =
              proxy(GetContact, request)
            def listContacts(
                request: ListContactsRequest
            ): ZStream[Any, AwsError, zio.aws.sesv2.model.Contact.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListContacts, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listContactsPaginated(
                request: ListContactsRequest
            ): IO[AwsError, zio.aws.sesv2.model.ListContactsResponse.ReadOnly] =
              proxy(ListContactsPaginated, request)
            def updateConfigurationSetEventDestination(
                request: UpdateConfigurationSetEventDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
            ] = proxy(UpdateConfigurationSetEventDestination, request)
            def putDedicatedIpInPool(request: PutDedicatedIpInPoolRequest): IO[
              AwsError,
              zio.aws.sesv2.model.PutDedicatedIpInPoolResponse.ReadOnly
            ] = proxy(PutDedicatedIpInPool, request)
            def getCustomVerificationEmailTemplate(
                request: GetCustomVerificationEmailTemplateRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetCustomVerificationEmailTemplateResponse.ReadOnly
            ] = proxy(GetCustomVerificationEmailTemplate, request)
            def sendCustomVerificationEmail(
                request: SendCustomVerificationEmailRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly
            ] = proxy(SendCustomVerificationEmail, request)
            def putConfigurationSetSendingOptions(
                request: PutConfigurationSetSendingOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetSendingOptions, request)
            def getSuppressedDestination(
                request: GetSuppressedDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetSuppressedDestinationResponse.ReadOnly
            ] = proxy(GetSuppressedDestination, request)
            def putConfigurationSetDeliveryOptions(
                request: PutConfigurationSetDeliveryOptionsRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetDeliveryOptions, request)
            def getDeliverabilityTestReport(
                request: GetDeliverabilityTestReportRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.GetDeliverabilityTestReportResponse.ReadOnly
            ] = proxy(GetDeliverabilityTestReport, request)
            def putAccountSuppressionAttributes(
                request: PutAccountSuppressionAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutAccountSuppressionAttributesResponse.ReadOnly
            ] = proxy(PutAccountSuppressionAttributes, request)
            def putDedicatedIpWarmupAttributes(
                request: PutDedicatedIpWarmupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
            ] = proxy(PutDedicatedIpWarmupAttributes, request)
            def deleteConfigurationSetEventDestination(
                request: DeleteConfigurationSetEventDestinationRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
            ] = proxy(DeleteConfigurationSetEventDestination, request)
            def putEmailIdentityDkimAttributes(
                request: PutEmailIdentityDkimAttributesRequest
            ): IO[
              AwsError,
              zio.aws.sesv2.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityDkimAttributes, request)
            def deleteContactList(request: DeleteContactListRequest): IO[
              AwsError,
              zio.aws.sesv2.model.DeleteContactListResponse.ReadOnly
            ] = proxy(DeleteContactList, request)
          }
        }
      }
    }
  }
}
