package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  CampaignId,
  Identity,
  ImageUrl,
  Ip,
  Percentage,
  Timestamp,
  Esp,
  Subject,
  Volume
}
import scala.jdk.CollectionConverters.*
final case class DomainDeliverabilityCampaign(
    campaignId: Optional[CampaignId] = Optional.Absent,
    imageUrl: Optional[ImageUrl] = Optional.Absent,
    subject: Optional[Subject] = Optional.Absent,
    fromAddress: Optional[Identity] = Optional.Absent,
    sendingIps: Optional[Iterable[Ip]] = Optional.Absent,
    firstSeenDateTime: Optional[Timestamp] = Optional.Absent,
    lastSeenDateTime: Optional[Timestamp] = Optional.Absent,
    inboxCount: Optional[Volume] = Optional.Absent,
    spamCount: Optional[Volume] = Optional.Absent,
    readRate: Optional[Percentage] = Optional.Absent,
    deleteRate: Optional[Percentage] = Optional.Absent,
    readDeleteRate: Optional[Percentage] = Optional.Absent,
    projectedVolume: Optional[Volume] = Optional.Absent,
    esps: Optional[Iterable[Esp]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign = {
    import DomainDeliverabilityCampaign.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign
      .builder()
      .optionallyWith(
        campaignId.map(value => CampaignId.unwrap(value): java.lang.String)
      )(_.campaignId)
      .optionallyWith(
        imageUrl.map(value => ImageUrl.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(
        subject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        fromAddress.map(value => Identity.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .optionallyWith(
        sendingIps.map(value =>
          value.map { item =>
            Ip.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sendingIps)
      .optionallyWith(
        firstSeenDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.firstSeenDateTime)
      .optionallyWith(
        lastSeenDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastSeenDateTime)
      .optionallyWith(
        inboxCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxCount)
      .optionallyWith(
        spamCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamCount)
      .optionallyWith(
        readRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readRate)
      .optionallyWith(
        deleteRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.deleteRate)
      .optionallyWith(
        readDeleteRate.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readDeleteRate)
      .optionallyWith(
        projectedVolume.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.projectedVolume)
      .optionallyWith(
        esps.map(value =>
          value.map { item =>
            Esp.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.esps)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly =
    zio.aws.sesv2.model.DomainDeliverabilityCampaign.wrap(buildAwsValue())
}
object DomainDeliverabilityCampaign {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DomainDeliverabilityCampaign =
      zio.aws.sesv2.model.DomainDeliverabilityCampaign(
        campaignId.map(value => value),
        imageUrl.map(value => value),
        subject.map(value => value),
        fromAddress.map(value => value),
        sendingIps.map(value => value),
        firstSeenDateTime.map(value => value),
        lastSeenDateTime.map(value => value),
        inboxCount.map(value => value),
        spamCount.map(value => value),
        readRate.map(value => value),
        deleteRate.map(value => value),
        readDeleteRate.map(value => value),
        projectedVolume.map(value => value),
        esps.map(value => value)
      )
    def campaignId: Optional[CampaignId]
    def imageUrl: Optional[ImageUrl]
    def subject: Optional[Subject]
    def fromAddress: Optional[Identity]
    def sendingIps: Optional[List[Ip]]
    def firstSeenDateTime: Optional[Timestamp]
    def lastSeenDateTime: Optional[Timestamp]
    def inboxCount: Optional[Volume]
    def spamCount: Optional[Volume]
    def readRate: Optional[Percentage]
    def deleteRate: Optional[Percentage]
    def readDeleteRate: Optional[Percentage]
    def projectedVolume: Optional[Volume]
    def esps: Optional[List[Esp]]
    def getCampaignId: ZIO[Any, AwsError, CampaignId] =
      AwsError.unwrapOptionField("campaignId", campaignId)
    def getImageUrl: ZIO[Any, AwsError, ImageUrl] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("subject", subject)
    def getFromAddress: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getSendingIps: ZIO[Any, AwsError, List[Ip]] =
      AwsError.unwrapOptionField("sendingIps", sendingIps)
    def getFirstSeenDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("firstSeenDateTime", firstSeenDateTime)
    def getLastSeenDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastSeenDateTime", lastSeenDateTime)
    def getInboxCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxCount", inboxCount)
    def getSpamCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamCount", spamCount)
    def getReadRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readRate", readRate)
    def getDeleteRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("deleteRate", deleteRate)
    def getReadDeleteRate: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readDeleteRate", readDeleteRate)
    def getProjectedVolume: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("projectedVolume", projectedVolume)
    def getEsps: ZIO[Any, AwsError, List[Esp]] =
      AwsError.unwrapOptionField("esps", esps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign
  ) extends zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly {
    override val campaignId: Optional[CampaignId] = zio.aws.core.internal
      .optionalFromNullable(impl.campaignId())
      .map(value => zio.aws.sesv2.model.primitives.CampaignId(value))
    override val imageUrl: Optional[ImageUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUrl())
      .map(value => zio.aws.sesv2.model.primitives.ImageUrl(value))
    override val subject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.subject())
      .map(value => zio.aws.sesv2.model.primitives.Subject(value))
    override val fromAddress: Optional[Identity] = zio.aws.core.internal
      .optionalFromNullable(impl.fromAddress())
      .map(value => zio.aws.sesv2.model.primitives.Identity(value))
    override val sendingIps: Optional[List[Ip]] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.Ip(item)
        }.toList
      )
    override val firstSeenDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSeenDateTime())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val lastSeenDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeenDateTime())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val inboxCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val spamCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.spamCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val readRate: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.readRate())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val deleteRate: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteRate())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val readDeleteRate: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.readDeleteRate())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val projectedVolume: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.projectedVolume())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val esps: Optional[List[Esp]] = zio.aws.core.internal
      .optionalFromNullable(impl.esps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.Esp(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DomainDeliverabilityCampaign
  ): zio.aws.sesv2.model.DomainDeliverabilityCampaign.ReadOnly = new Wrapper(
    impl
  )
}
