package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateImportJobRequest(
    importDestination: zio.aws.sesv2.model.ImportDestination,
    importDataSource: zio.aws.sesv2.model.ImportDataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest = {
    import CreateImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest
      .builder()
      .importDestination(importDestination.buildAwsValue())
      .importDataSource(importDataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateImportJobRequest.ReadOnly =
    zio.aws.sesv2.model.CreateImportJobRequest.wrap(buildAwsValue())
}
object CreateImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateImportJobRequest =
      zio.aws.sesv2.model.CreateImportJobRequest(
        importDestination.asEditable,
        importDataSource.asEditable
      )
    def importDestination: zio.aws.sesv2.model.ImportDestination.ReadOnly
    def importDataSource: zio.aws.sesv2.model.ImportDataSource.ReadOnly
    def getImportDestination
        : ZIO[Any, Nothing, zio.aws.sesv2.model.ImportDestination.ReadOnly] =
      ZIO.succeed(importDestination)
    def getImportDataSource
        : ZIO[Any, Nothing, zio.aws.sesv2.model.ImportDataSource.ReadOnly] =
      ZIO.succeed(importDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest
  ) extends zio.aws.sesv2.model.CreateImportJobRequest.ReadOnly {
    override val importDestination
        : zio.aws.sesv2.model.ImportDestination.ReadOnly =
      zio.aws.sesv2.model.ImportDestination.wrap(impl.importDestination())
    override val importDataSource
        : zio.aws.sesv2.model.ImportDataSource.ReadOnly =
      zio.aws.sesv2.model.ImportDataSource.wrap(impl.importDataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateImportJobRequest
  ): zio.aws.sesv2.model.CreateImportJobRequest.ReadOnly = new Wrapper(impl)
}
