package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, UnsubscribeAll, EmailAddress}
import scala.jdk.CollectionConverters.*
final case class Contact(
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    topicPreferences: Optional[Iterable[zio.aws.sesv2.model.TopicPreference]] =
      Optional.Absent,
    topicDefaultPreferences: Optional[
      Iterable[zio.aws.sesv2.model.TopicPreference]
    ] = Optional.Absent,
    unsubscribeAll: Optional[UnsubscribeAll] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Contact
      .builder()
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        topicPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicPreferences)
      .optionallyWith(
        topicDefaultPreferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicDefaultPreferences)
      .optionallyWith(
        unsubscribeAll.map(value =>
          UnsubscribeAll.unwrap(value): java.lang.Boolean
        )
      )(_.unsubscribeAll)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Contact.ReadOnly =
    zio.aws.sesv2.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Contact] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Contact = zio.aws.sesv2.model.Contact(
      emailAddress.map(value => value),
      topicPreferences.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      topicDefaultPreferences.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      unsubscribeAll.map(value => value),
      lastUpdatedTimestamp.map(value => value)
    )
    def emailAddress: Optional[EmailAddress]
    def topicPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def topicDefaultPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]]
    def unsubscribeAll: Optional[UnsubscribeAll]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getTopicPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField("topicPreferences", topicPreferences)
    def getTopicDefaultPreferences: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.TopicPreference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "topicDefaultPreferences",
      topicDefaultPreferences
    )
    def getUnsubscribeAll: ZIO[Any, AwsError, UnsubscribeAll] =
      AwsError.unwrapOptionField("unsubscribeAll", unsubscribeAll)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Contact
  ) extends zio.aws.sesv2.model.Contact.ReadOnly {
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val topicPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicPreferences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.TopicPreference.wrap(item)
          }.toList
        )
    override val topicDefaultPreferences
        : Optional[List[zio.aws.sesv2.model.TopicPreference.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicDefaultPreferences())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.TopicPreference.wrap(item)
          }.toList
        )
    override val unsubscribeAll: Optional[UnsubscribeAll] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsubscribeAll())
        .map(value => zio.aws.sesv2.model.primitives.UnsubscribeAll(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Contact
  ): zio.aws.sesv2.model.Contact.ReadOnly = new Wrapper(impl)
}
