package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken, Timestamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSuppressedDestinationsRequest(
    reasons: Optional[Iterable[zio.aws.sesv2.model.SuppressionListReason]] =
      Optional.Absent,
    startDate: Optional[Timestamp] = Optional.Absent,
    endDate: Optional[Timestamp] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest = {
    import ListSuppressedDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest
      .builder()
      .optionallyWith(
        reasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.reasonsWithStrings)
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.ListSuppressedDestinationsRequest.ReadOnly =
    zio.aws.sesv2.model.ListSuppressedDestinationsRequest.wrap(buildAwsValue())
}
object ListSuppressedDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListSuppressedDestinationsRequest =
      zio.aws.sesv2.model.ListSuppressedDestinationsRequest(
        reasons.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def reasons: Optional[List[zio.aws.sesv2.model.SuppressionListReason]]
    def startDate: Optional[Timestamp]
    def endDate: Optional[Timestamp]
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getReasons
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.SuppressionListReason]] =
      AwsError.unwrapOptionField("reasons", reasons)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest
  ) extends zio.aws.sesv2.model.ListSuppressedDestinationsRequest.ReadOnly {
    override val reasons
        : Optional[List[zio.aws.sesv2.model.SuppressionListReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.SuppressionListReason.wrap(item)
          }.toList
        )
    override val startDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val endDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListSuppressedDestinationsRequest
  ): zio.aws.sesv2.model.ListSuppressedDestinationsRequest.ReadOnly =
    new Wrapper(impl)
}
