package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait DataFormat {
  def unwrap: software.amazon.awssdk.services.sesv2.model.DataFormat
}
object DataFormat {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.DataFormat
  ): zio.aws.sesv2.model.DataFormat = value match {
    case software.amazon.awssdk.services.sesv2.model.DataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.DataFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.sesv2.model.DataFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DataFormat =
      software.amazon.awssdk.services.sesv2.model.DataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.sesv2.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DataFormat =
      software.amazon.awssdk.services.sesv2.model.DataFormat.CSV
  }
  case object JSON extends zio.aws.sesv2.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DataFormat =
      software.amazon.awssdk.services.sesv2.model.DataFormat.JSON
  }
}
