package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateName,
  EmailAddress,
  EmailTemplateSubject,
  FailureRedirectionURL,
  SuccessRedirectionURL
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomVerificationEmailTemplateMetadata(
    templateName: Optional[EmailTemplateName] = Optional.Absent,
    fromEmailAddress: Optional[EmailAddress] = Optional.Absent,
    templateSubject: Optional[EmailTemplateSubject] = Optional.Absent,
    successRedirectionURL: Optional[SuccessRedirectionURL] = Optional.Absent,
    failureRedirectionURL: Optional[FailureRedirectionURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata = {
    import CustomVerificationEmailTemplateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
      .builder()
      .optionallyWith(
        templateName.map(value =>
          EmailTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value =>
          EmailTemplateSubject.unwrap(value): java.lang.String
        )
      )(_.templateSubject)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly =
    zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata
      .wrap(buildAwsValue())
}
object CustomVerificationEmailTemplateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata =
      zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata(
        templateName.map(value => value),
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: Optional[EmailTemplateName]
    def fromEmailAddress: Optional[EmailAddress]
    def templateSubject: Optional[EmailTemplateSubject]
    def successRedirectionURL: Optional[SuccessRedirectionURL]
    def failureRedirectionURL: Optional[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, AwsError, EmailTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, EmailTemplateSubject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ) extends zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly {
    override val templateName: Optional[EmailTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateName())
        .map(value => zio.aws.sesv2.model.primitives.EmailTemplateName(value))
    override val fromEmailAddress: Optional[EmailAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromEmailAddress())
        .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val templateSubject: Optional[EmailTemplateSubject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSubject())
        .map(value =>
          zio.aws.sesv2.model.primitives.EmailTemplateSubject(value)
        )
    override val successRedirectionURL: Optional[SuccessRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRedirectionURL())
        .map(value =>
          zio.aws.sesv2.model.primitives.SuccessRedirectionURL(value)
        )
    override val failureRedirectionURL: Optional[FailureRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRedirectionURL())
        .map(value =>
          zio.aws.sesv2.model.primitives.FailureRedirectionURL(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CustomVerificationEmailTemplateMetadata
  ): zio.aws.sesv2.model.CustomVerificationEmailTemplateMetadata.ReadOnly =
    new Wrapper(impl)
}
