package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAccountSendingAttributesRequest(
    sendingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest = {
    import PutAccountSendingAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest
      .builder()
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutAccountSendingAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutAccountSendingAttributesRequest.wrap(buildAwsValue())
}
object PutAccountSendingAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutAccountSendingAttributesRequest =
      zio.aws.sesv2.model
        .PutAccountSendingAttributesRequest(sendingEnabled.map(value => value))
    def sendingEnabled: Optional[Enabled]
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest
  ) extends zio.aws.sesv2.model.PutAccountSendingAttributesRequest.ReadOnly {
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest
  ): zio.aws.sesv2.model.PutAccountSendingAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
