package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailAddress
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSuppressedDestinationRequest(emailAddress: EmailAddress) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest = {
    import GetSuppressedDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetSuppressedDestinationRequest.ReadOnly =
    zio.aws.sesv2.model.GetSuppressedDestinationRequest.wrap(buildAwsValue())
}
object GetSuppressedDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetSuppressedDestinationRequest =
      zio.aws.sesv2.model.GetSuppressedDestinationRequest(emailAddress)
    def emailAddress: EmailAddress
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest
  ) extends zio.aws.sesv2.model.GetSuppressedDestinationRequest.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetSuppressedDestinationRequest
  ): zio.aws.sesv2.model.GetSuppressedDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
