package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConfigurationSetRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest = {
    import GetConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetConfigurationSetRequest.ReadOnly =
    zio.aws.sesv2.model.GetConfigurationSetRequest.wrap(buildAwsValue())
}
object GetConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetConfigurationSetRequest =
      zio.aws.sesv2.model.GetConfigurationSetRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest
  ) extends zio.aws.sesv2.model.GetConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest
  ): zio.aws.sesv2.model.GetConfigurationSetRequest.ReadOnly = new Wrapper(impl)
}
