package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConfigurationSetEventDestinationsRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest = {
    import GetConfigurationSetEventDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest.ReadOnly =
    zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest
      .wrap(buildAwsValue())
}
object GetConfigurationSetEventDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest =
      zio.aws.sesv2.model
        .GetConfigurationSetEventDestinationsRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest
  ) extends zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest
  ): zio.aws.sesv2.model.GetConfigurationSetEventDestinationsRequest.ReadOnly =
    new Wrapper(impl)
}
