package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{PrivateKey, Selector}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DkimSigningAttributes(
    domainSigningSelector: Optional[Selector] = Optional.Absent,
    domainSigningPrivateKey: Optional[PrivateKey] = Optional.Absent,
    nextSigningKeyLength: Optional[zio.aws.sesv2.model.DkimSigningKeyLength] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes = {
    import DkimSigningAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes
      .builder()
      .optionallyWith(
        domainSigningSelector.map(value =>
          Selector.unwrap(value): java.lang.String
        )
      )(_.domainSigningSelector)
      .optionallyWith(
        domainSigningPrivateKey.map(value =>
          PrivateKey.unwrap(value): java.lang.String
        )
      )(_.domainSigningPrivateKey)
      .optionallyWith(nextSigningKeyLength.map(value => value.unwrap))(
        _.nextSigningKeyLength
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly =
    zio.aws.sesv2.model.DkimSigningAttributes.wrap(buildAwsValue())
}
object DkimSigningAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DkimSigningAttributes =
      zio.aws.sesv2.model.DkimSigningAttributes(
        domainSigningSelector.map(value => value),
        domainSigningPrivateKey.map(value => value),
        nextSigningKeyLength.map(value => value)
      )
    def domainSigningSelector: Optional[Selector]
    def domainSigningPrivateKey: Optional[PrivateKey]
    def nextSigningKeyLength: Optional[zio.aws.sesv2.model.DkimSigningKeyLength]
    def getDomainSigningSelector: ZIO[Any, AwsError, Selector] =
      AwsError.unwrapOptionField("domainSigningSelector", domainSigningSelector)
    def getDomainSigningPrivateKey: ZIO[Any, AwsError, PrivateKey] = AwsError
      .unwrapOptionField("domainSigningPrivateKey", domainSigningPrivateKey)
    def getNextSigningKeyLength
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimSigningKeyLength] =
      AwsError.unwrapOptionField("nextSigningKeyLength", nextSigningKeyLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes
  ) extends zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly {
    override val domainSigningSelector: Optional[Selector] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSigningSelector())
        .map(value => zio.aws.sesv2.model.primitives.Selector(value))
    override val domainSigningPrivateKey: Optional[PrivateKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSigningPrivateKey())
        .map(value => zio.aws.sesv2.model.primitives.PrivateKey(value))
    override val nextSigningKeyLength
        : Optional[zio.aws.sesv2.model.DkimSigningKeyLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextSigningKeyLength())
        .map(value => zio.aws.sesv2.model.DkimSigningKeyLength.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DkimSigningAttributes
  ): zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly = new Wrapper(impl)
}
