package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationSetRequest(
    configurationSetName: ConfigurationSetName,
    trackingOptions: Optional[zio.aws.sesv2.model.TrackingOptions] =
      Optional.Absent,
    deliveryOptions: Optional[zio.aws.sesv2.model.DeliveryOptions] =
      Optional.Absent,
    reputationOptions: Optional[zio.aws.sesv2.model.ReputationOptions] =
      Optional.Absent,
    sendingOptions: Optional[zio.aws.sesv2.model.SendingOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sesv2.model.Tag]] = Optional.Absent,
    suppressionOptions: Optional[zio.aws.sesv2.model.SuppressionOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest = {
    import CreateConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(trackingOptions.map(value => value.buildAwsValue()))(
        _.trackingOptions
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .optionallyWith(reputationOptions.map(value => value.buildAwsValue()))(
        _.reputationOptions
      )
      .optionallyWith(sendingOptions.map(value => value.buildAwsValue()))(
        _.sendingOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(suppressionOptions.map(value => value.buildAwsValue()))(
        _.suppressionOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly =
    zio.aws.sesv2.model.CreateConfigurationSetRequest.wrap(buildAwsValue())
}
object CreateConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateConfigurationSetRequest =
      zio.aws.sesv2.model.CreateConfigurationSetRequest(
        configurationSetName,
        trackingOptions.map(value => value.asEditable),
        deliveryOptions.map(value => value.asEditable),
        reputationOptions.map(value => value.asEditable),
        sendingOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        suppressionOptions.map(value => value.asEditable)
      )
    def configurationSetName: ConfigurationSetName
    def trackingOptions: Optional[zio.aws.sesv2.model.TrackingOptions.ReadOnly]
    def deliveryOptions: Optional[zio.aws.sesv2.model.DeliveryOptions.ReadOnly]
    def reputationOptions
        : Optional[zio.aws.sesv2.model.ReputationOptions.ReadOnly]
    def sendingOptions: Optional[zio.aws.sesv2.model.SendingOptions.ReadOnly]
    def tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def suppressionOptions
        : Optional[zio.aws.sesv2.model.SuppressionOptions.ReadOnly]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTrackingOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.TrackingOptions.ReadOnly] =
      AwsError.unwrapOptionField("trackingOptions", trackingOptions)
    def getDeliveryOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DeliveryOptions.ReadOnly] =
      AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
    def getReputationOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ReputationOptions.ReadOnly] =
      AwsError.unwrapOptionField("reputationOptions", reputationOptions)
    def getSendingOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SendingOptions.ReadOnly] =
      AwsError.unwrapOptionField("sendingOptions", sendingOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSuppressionOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.SuppressionOptions.ReadOnly] =
      AwsError.unwrapOptionField("suppressionOptions", suppressionOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ) extends zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val trackingOptions
        : Optional[zio.aws.sesv2.model.TrackingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trackingOptions())
        .map(value => zio.aws.sesv2.model.TrackingOptions.wrap(value))
    override val deliveryOptions
        : Optional[zio.aws.sesv2.model.DeliveryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryOptions())
        .map(value => zio.aws.sesv2.model.DeliveryOptions.wrap(value))
    override val reputationOptions
        : Optional[zio.aws.sesv2.model.ReputationOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reputationOptions())
        .map(value => zio.aws.sesv2.model.ReputationOptions.wrap(value))
    override val sendingOptions
        : Optional[zio.aws.sesv2.model.SendingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendingOptions())
        .map(value => zio.aws.sesv2.model.SendingOptions.wrap(value))
    override val tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Tag.wrap(item)
          }.toList
        )
    override val suppressionOptions
        : Optional[zio.aws.sesv2.model.SuppressionOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressionOptions())
        .map(value => zio.aws.sesv2.model.SuppressionOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest
  ): zio.aws.sesv2.model.CreateConfigurationSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
