package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EmailTemplateName,
  EmailAddress,
  EmailTemplateSubject,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCustomVerificationEmailTemplateRequest(
    templateName: EmailTemplateName,
    fromEmailAddress: EmailAddress,
    templateSubject: EmailTemplateSubject,
    templateContent: TemplateContent,
    successRedirectionURL: SuccessRedirectionURL,
    failureRedirectionURL: FailureRedirectionURL
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest = {
    import UpdateCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .fromEmailAddress(EmailAddress.unwrap(fromEmailAddress): java.lang.String)
      .templateSubject(
        EmailTemplateSubject.unwrap(templateSubject): java.lang.String
      )
      .templateContent(
        TemplateContent.unwrap(templateContent): java.lang.String
      )
      .successRedirectionURL(
        SuccessRedirectionURL.unwrap(successRedirectionURL): java.lang.String
      )
      .failureRedirectionURL(
        FailureRedirectionURL.unwrap(failureRedirectionURL): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest =
      zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest(
        templateName,
        fromEmailAddress,
        templateSubject,
        templateContent,
        successRedirectionURL,
        failureRedirectionURL
      )
    def templateName: EmailTemplateName
    def fromEmailAddress: EmailAddress
    def templateSubject: EmailTemplateSubject
    def templateContent: TemplateContent
    def successRedirectionURL: SuccessRedirectionURL
    def failureRedirectionURL: FailureRedirectionURL
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
    def getFromEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(fromEmailAddress)
    def getTemplateSubject: ZIO[Any, Nothing, EmailTemplateSubject] =
      ZIO.succeed(templateSubject)
    def getTemplateContent: ZIO[Any, Nothing, TemplateContent] =
      ZIO.succeed(templateContent)
    def getSuccessRedirectionURL: ZIO[Any, Nothing, SuccessRedirectionURL] =
      ZIO.succeed(successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, Nothing, FailureRedirectionURL] =
      ZIO.succeed(failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
  ) extends zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
    override val fromEmailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.fromEmailAddress())
    override val templateSubject: EmailTemplateSubject =
      zio.aws.sesv2.model.primitives
        .EmailTemplateSubject(impl.templateSubject())
    override val templateContent: TemplateContent =
      zio.aws.sesv2.model.primitives.TemplateContent(impl.templateContent())
    override val successRedirectionURL: SuccessRedirectionURL =
      zio.aws.sesv2.model.primitives
        .SuccessRedirectionURL(impl.successRedirectionURL())
    override val failureRedirectionURL: FailureRedirectionURL =
      zio.aws.sesv2.model.primitives
        .FailureRedirectionURL(impl.failureRedirectionURL())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateCustomVerificationEmailTemplateRequest
  ): zio.aws.sesv2.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
