package zio.aws.sesv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{MaxItems, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListImportJobsRequest(
    importDestinationType: Optional[zio.aws.sesv2.model.ImportDestinationType] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest = {
    import ListImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest
      .builder()
      .optionallyWith(importDestinationType.map(value => value.unwrap))(
        _.importDestinationType
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListImportJobsRequest.ReadOnly =
    zio.aws.sesv2.model.ListImportJobsRequest.wrap(buildAwsValue())
}
object ListImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListImportJobsRequest =
      zio.aws.sesv2.model.ListImportJobsRequest(
        importDestinationType.map(value => value),
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def importDestinationType
        : Optional[zio.aws.sesv2.model.ImportDestinationType]
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getImportDestinationType
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ImportDestinationType] =
      AwsError.unwrapOptionField("importDestinationType", importDestinationType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest
  ) extends zio.aws.sesv2.model.ListImportJobsRequest.ReadOnly {
    override val importDestinationType
        : Optional[zio.aws.sesv2.model.ImportDestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importDestinationType())
        .map(value => zio.aws.sesv2.model.ImportDestinationType.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.sesv2.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest
  ): zio.aws.sesv2.model.ListImportJobsRequest.ReadOnly = new Wrapper(impl)
}
