package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportDestination(
    suppressionListDestination: Optional[
      zio.aws.sesv2.model.SuppressionListDestination
    ] = Optional.Absent,
    contactListDestination: Optional[
      zio.aws.sesv2.model.ContactListDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ImportDestination = {
    import ImportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ImportDestination
      .builder()
      .optionallyWith(
        suppressionListDestination.map(value => value.buildAwsValue())
      )(_.suppressionListDestination)
      .optionallyWith(
        contactListDestination.map(value => value.buildAwsValue())
      )(_.contactListDestination)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ImportDestination.ReadOnly =
    zio.aws.sesv2.model.ImportDestination.wrap(buildAwsValue())
}
object ImportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ImportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ImportDestination =
      zio.aws.sesv2.model.ImportDestination(
        suppressionListDestination.map(value => value.asEditable),
        contactListDestination.map(value => value.asEditable)
      )
    def suppressionListDestination
        : Optional[zio.aws.sesv2.model.SuppressionListDestination.ReadOnly]
    def contactListDestination
        : Optional[zio.aws.sesv2.model.ContactListDestination.ReadOnly]
    def getSuppressionListDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.SuppressionListDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "suppressionListDestination",
      suppressionListDestination
    )
    def getContactListDestination: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.ContactListDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contactListDestination",
      contactListDestination
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDestination
  ) extends zio.aws.sesv2.model.ImportDestination.ReadOnly {
    override val suppressionListDestination
        : Optional[zio.aws.sesv2.model.SuppressionListDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suppressionListDestination())
        .map(value =>
          zio.aws.sesv2.model.SuppressionListDestination.wrap(value)
        )
    override val contactListDestination
        : Optional[zio.aws.sesv2.model.ContactListDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactListDestination())
        .map(value => zio.aws.sesv2.model.ContactListDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ImportDestination
  ): zio.aws.sesv2.model.ImportDestination.ReadOnly = new Wrapper(impl)
}
