package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityPoliciesRequest(emailIdentity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest = {
    import GetEmailIdentityPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest.ReadOnly =
    zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest.wrap(buildAwsValue())
}
object GetEmailIdentityPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest =
      zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest(emailIdentity)
    def emailIdentity: Identity
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest
  ) extends zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesRequest
  ): zio.aws.sesv2.model.GetEmailIdentityPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
