package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, Enabled}
import scala.jdk.CollectionConverters.*
final case class GetDeliverabilityDashboardOptionsResponse(
    dashboardEnabled: Enabled,
    subscriptionExpiryDate: Optional[Timestamp] = Optional.Absent,
    accountStatus: Optional[
      zio.aws.sesv2.model.DeliverabilityDashboardAccountStatus
    ] = Optional.Absent,
    activeSubscribedDomains: Optional[
      Iterable[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption]
    ] = Optional.Absent,
    pendingExpirationSubscribedDomains: Optional[
      Iterable[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse = {
    import GetDeliverabilityDashboardOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse
      .builder()
      .dashboardEnabled(Enabled.unwrap(dashboardEnabled): java.lang.Boolean)
      .optionallyWith(
        subscriptionExpiryDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionExpiryDate)
      .optionallyWith(accountStatus.map(value => value.unwrap))(_.accountStatus)
      .optionallyWith(
        activeSubscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeSubscribedDomains)
      .optionallyWith(
        pendingExpirationSubscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingExpirationSubscribedDomains)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly =
    zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse
      .wrap(buildAwsValue())
}
object GetDeliverabilityDashboardOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse =
      zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse(
        dashboardEnabled,
        subscriptionExpiryDate.map(value => value),
        accountStatus.map(value => value),
        activeSubscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingExpirationSubscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dashboardEnabled: Enabled
    def subscriptionExpiryDate: Optional[Timestamp]
    def accountStatus
        : Optional[zio.aws.sesv2.model.DeliverabilityDashboardAccountStatus]
    def activeSubscribedDomains: Optional[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ]
    def pendingExpirationSubscribedDomains: Optional[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ]
    def getDashboardEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(dashboardEnabled)
    def getSubscriptionExpiryDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("subscriptionExpiryDate", subscriptionExpiryDate)
    def getAccountStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.DeliverabilityDashboardAccountStatus
    ] = AwsError.unwrapOptionField("accountStatus", accountStatus)
    def getActiveSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "activeSubscribedDomains",
      activeSubscribedDomains
    )
    def getPendingExpirationSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingExpirationSubscribedDomains",
      pendingExpirationSubscribedDomains
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse
  ) extends zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly {
    override val dashboardEnabled: Enabled =
      zio.aws.sesv2.model.primitives.Enabled(impl.dashboardEnabled())
    override val subscriptionExpiryDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionExpiryDate())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val accountStatus
        : Optional[zio.aws.sesv2.model.DeliverabilityDashboardAccountStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountStatus())
        .map(value =>
          zio.aws.sesv2.model.DeliverabilityDashboardAccountStatus.wrap(value)
        )
    override val activeSubscribedDomains: Optional[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeSubscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.wrap(item)
        }.toList
      )
    override val pendingExpirationSubscribedDomains: Optional[
      List[zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingExpirationSubscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.DomainDeliverabilityTrackingOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse
  ): zio.aws.sesv2.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
