package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Percentage, Volume, IspName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainIspPlacement(
    ispName: Optional[IspName] = Optional.Absent,
    inboxRawCount: Optional[Volume] = Optional.Absent,
    spamRawCount: Optional[Volume] = Optional.Absent,
    inboxPercentage: Optional[Percentage] = Optional.Absent,
    spamPercentage: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DomainIspPlacement = {
    import DomainIspPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DomainIspPlacement
      .builder()
      .optionallyWith(
        ispName.map(value => IspName.unwrap(value): java.lang.String)
      )(_.ispName)
      .optionallyWith(
        inboxRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.inboxRawCount)
      .optionallyWith(
        spamRawCount.map(value => Volume.unwrap(value): java.lang.Long)
      )(_.spamRawCount)
      .optionallyWith(
        inboxPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.inboxPercentage)
      .optionallyWith(
        spamPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spamPercentage)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DomainIspPlacement.ReadOnly =
    zio.aws.sesv2.model.DomainIspPlacement.wrap(buildAwsValue())
}
object DomainIspPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DomainIspPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DomainIspPlacement =
      zio.aws.sesv2.model.DomainIspPlacement(
        ispName.map(value => value),
        inboxRawCount.map(value => value),
        spamRawCount.map(value => value),
        inboxPercentage.map(value => value),
        spamPercentage.map(value => value)
      )
    def ispName: Optional[IspName]
    def inboxRawCount: Optional[Volume]
    def spamRawCount: Optional[Volume]
    def inboxPercentage: Optional[Percentage]
    def spamPercentage: Optional[Percentage]
    def getIspName: ZIO[Any, AwsError, IspName] =
      AwsError.unwrapOptionField("ispName", ispName)
    def getInboxRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("inboxRawCount", inboxRawCount)
    def getSpamRawCount: ZIO[Any, AwsError, Volume] =
      AwsError.unwrapOptionField("spamRawCount", spamRawCount)
    def getInboxPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("inboxPercentage", inboxPercentage)
    def getSpamPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spamPercentage", spamPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DomainIspPlacement
  ) extends zio.aws.sesv2.model.DomainIspPlacement.ReadOnly {
    override val ispName: Optional[IspName] = zio.aws.core.internal
      .optionalFromNullable(impl.ispName())
      .map(value => zio.aws.sesv2.model.primitives.IspName(value))
    override val inboxRawCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val spamRawCount: Optional[Volume] = zio.aws.core.internal
      .optionalFromNullable(impl.spamRawCount())
      .map(value => zio.aws.sesv2.model.primitives.Volume(value))
    override val inboxPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val spamPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.spamPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DomainIspPlacement
  ): zio.aws.sesv2.model.DomainIspPlacement.ReadOnly = new Wrapper(impl)
}
